package ru.yandex.autotests.direct.api.creatives;

import com.yandex.direct.api.v5.creatives.BusinessTypeEnum;
import com.yandex.direct.api.v5.creatives.CreativeFieldEnum;
import com.yandex.direct.api.v5.creatives.CreativeGetItem;
import com.yandex.direct.api.v5.creatives.GetRequest;
import com.yandex.direct.api.v5.creatives.ObjectFactory;
import com.yandex.direct.api.v5.creatives.SmartCreativeFieldEnum;

import static java.util.Collections.singleton;

public class TestCreatives {

    private static final ObjectFactory FACTORY = new ObjectFactory();

    static GetRequest createGetRequest(Long creativeId) {
        return new GetRequest()
                .withSelectionCriteria(
                        FACTORY.createCreativesSelectionCriteria()
                                .withIds(singleton(creativeId)))
                .withFieldNames(CreativeFieldEnum.values())
                .withSmartCreativeFieldNames(SmartCreativeFieldEnum.values());
    }

    static CreativeGetItem getCreativeGetItem(Long creativeId, String creativeName, Long groupId, String groupName,
                                              BusinessTypeEnum businessType) {
        return FACTORY.createCreativeGetItem()
                .withId(creativeId)
                .withName(creativeName)
                .withSmartCreative(
                        FACTORY.createSmartCreativeGet()
                                .withCreativeGroupId(groupId)
                                .withCreativeGroupName(groupName)
                                .withBusinessType(businessType));
    }

}
