package ru.yandex.autotests.direct.api.feeds;

import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.feed.model.Feed;
import ru.yandex.direct.core.entity.feed.model.Source;
import ru.yandex.direct.core.entity.feed.model.UpdateStatus;
import ru.yandex.direct.dbutil.model.ClientId;

public class TestFeeds {

    public static Feed buildFileFeed(ClientId clientId) {
        return new Feed()
                .withClientId(clientId.asLong())
                .withName("feed name")
                .withFilename("feed.xml")
                .withUrl("http://storage-int.mdst.yandex.net/get-direct-files/1214/perf_feeds/108250453/hashhash")
                .withCachedFileHash("hashhash")
                .withOffersCount(20L)
                .withRefreshInterval(10L)
                .withUpdateStatus(UpdateStatus.DONE)
                .withBusinessType(BusinessType.AUTO)
                .withSource(Source.FILE);
    }

    public static Feed buildUrlFeed(ClientId clientId) {
        return new Feed()
                .withClientId(clientId.asLong())
                .withName("feed name")
                .withUrl("http://mysite.com/feeds/feed1.xml")
                .withOffersCount(20L)
                .withRefreshInterval(10L)
                .withUpdateStatus(UpdateStatus.DONE)
                .withBusinessType(BusinessType.HOTELS)
                .withSource(Source.URL);
    }
}
