package ru.yandex.autotests.direct.api.feeds.add;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.feeds.AddRequest;
import com.yandex.direct.api.v5.feeds.AddResponse;
import com.yandex.direct.api.v5.feeds.BusinessTypeEnum;
import com.yandex.direct.api.v5.feeds.FeedAddItem;
import com.yandex.direct.api.v5.feeds.FileFeedAdd;
import com.yandex.direct.api.v5.feeds.SourceTypeEnum;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.direct.api.feeds.FeedsFeatures;
import ru.yandex.autotests.directapi.apiclient.ApiClient;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.data.TestRoleRelation;
import ru.yandex.direct.core.testing.info.RoleRelationInfo;
import ru.yandex.qatools.allure.annotations.Features;

import static org.assertj.core.api.Assertions.assertThat;
import static ru.yandex.autotests.directapi.model.api5.Action.ADD;
import static ru.yandex.autotests.directapi.model.api5.ServiceNames.FEEDS;

@Features(FeedsFeatures.ADD)
@RunWith(Parameterized.class)
public class AddFeedsByRolesTest {

    @Parameterized.Parameter
    public String description;
    @Parameterized.Parameter(1)
    public TestRoleRelation roleRelation;
    @Parameterized.Parameter(2)
    public Object expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static List<Object[]> testData() {
        Object[][] data = new Object[][]{
                {"Главный представитель", TestRoleRelation.CLIENT_CHIEF_AND_SAME_CLIENT, "size=1"},
                {"Посторонний клиент", TestRoleRelation.CLIENT_AND_OTHER_CLIENT, "Объект не найден"},
                {"Агенство и клиент", TestRoleRelation.AGENCY_AND_SUB_CLIENT, "size=1"},
                {"IDM менеджер и клиент", TestRoleRelation.IDM_MANAGER_AND_CLIENT, "size=1"},
                {"Менеджер и его клиент", TestRoleRelation.CLIENT_MANAGER_AND_CLIENT, "size=1"},
                {"Представитель клиента", TestRoleRelation.REP_AND_CHIEF, "size=1"},
                {"Суперпользователь", TestRoleRelation.SUPER_AND_CLIENT, "size=1"},
                {"Суперриадер", TestRoleRelation.SUPER_READER_AND_CLIENT, "Нет прав"},
                {"Саппорт", TestRoleRelation.SUPPORT_AND_CLIENT, "size=1"},
        };
        return Arrays.asList(data);
    }

    @Test
    public void add() {
        ApiSteps api = new ApiSteps();

        RoleRelationInfo roleRelationInfo = api.coreSteps().rolesSteps().getRoleRelationInfo(roleRelation);
        api.as(roleRelationInfo.getOperatorUserInfo().getUser());

        FeedAddItem item = getFileFeedAddItem("filename.csv");
        var request = new AddRequest().withFeeds(item);
        ApiClient apiClient = api.userSteps().feedSteps().defaultClientV5();
        String clientLogin = roleRelationInfo.getOwnerUserInfo().getLogin();

        Object result;
        try {
            AddResponse response = apiClient.invokeMethod(FEEDS, clientLogin, ADD, request);
            result = "size=" + response.getAddResults().size();
        } catch (Exception ex) {
            result = ex.getMessage();
        }
        assertThat(result).as("Результат").isEqualTo(expectedResult);
    }

    private FeedAddItem getFileFeedAddItem(String filename) {
        var fileFeed = new FileFeedAdd()
                .withFilename(filename)
                .withData("<xml></xml>".getBytes());
        return new FeedAddItem()
                .withName("name")
                .withBusinessType(BusinessTypeEnum.FLIGHTS)
                .withSourceType(SourceTypeEnum.FILE)
                .withFileFeed(fileFeed);
    }

}
