package ru.yandex.autotests.direct.api.feeds.delete;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.feeds.DeleteRequest;
import com.yandex.direct.api.v5.feeds.DeleteResponse;
import com.yandex.direct.api.v5.feeds.FeedsSelectionCriteria;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.direct.api.feeds.FeedsFeatures;
import ru.yandex.autotests.directapi.apiclient.ApiClient;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.entity.feed.model.UpdateStatus;
import ru.yandex.direct.core.testing.data.TestRoleRelation;
import ru.yandex.direct.core.testing.info.FeedInfo;
import ru.yandex.direct.core.testing.info.RoleRelationInfo;
import ru.yandex.qatools.allure.annotations.Features;

import static org.assertj.core.api.Assertions.assertThat;
import static ru.yandex.autotests.directapi.model.api5.Action.DELETE;
import static ru.yandex.autotests.directapi.model.api5.ServiceNames.FEEDS;
import static ru.yandex.direct.core.testing.data.TestFeeds.defaultFeed;

@Features(FeedsFeatures.DELETE)
@RunWith(Parameterized.class)
public class DeleteFeedsByRolesTest {

    @Parameterized.Parameter
    public String description;
    @Parameterized.Parameter(1)
    public TestRoleRelation roleRelation;
    @Parameterized.Parameter(2)
    public Object expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static List<Object[]> testData() {
        Object[][] data = new Object[][]{
                {"Главный представитель", TestRoleRelation.CLIENT_CHIEF_AND_SAME_CLIENT, "size=1"},
                {"Посторонний клиент", TestRoleRelation.CLIENT_AND_OTHER_CLIENT, "Объект не найден"},
                {"Агенство и клиент", TestRoleRelation.AGENCY_AND_SUB_CLIENT, "size=1"},
                {"IDM менеджер и клиент", TestRoleRelation.IDM_MANAGER_AND_CLIENT, "size=1"},
                {"Менеджер и его клиент", TestRoleRelation.CLIENT_MANAGER_AND_CLIENT, "size=1"},
                {"Представитель клиента", TestRoleRelation.REP_AND_CHIEF, "size=1"},
                {"Суперпользователь", TestRoleRelation.SUPER_AND_CLIENT, "size=1"},
                {"Суперриадер", TestRoleRelation.SUPER_READER_AND_CLIENT, "Нет прав"},
                {"Саппорт", TestRoleRelation.SUPPORT_AND_CLIENT, "size=1"},
        };
        return Arrays.asList(data);
    }

    @Test
    public void delete() {
        ApiSteps api = new ApiSteps();

        RoleRelationInfo roleRelationInfo = api.coreSteps().rolesSteps().getRoleRelationInfo(roleRelation);
        api.as(roleRelationInfo.getOperatorUserInfo().getUser());

        FeedInfo feedInfo = new FeedInfo()
                .withClientInfo(roleRelationInfo.getOwnerClientInfo())
                .withFeed(
                        defaultFeed(roleRelationInfo.getOwnerClientInfo().getClientId())
                                .withUpdateStatus(UpdateStatus.ERROR));
        api.coreSteps().feedSteps().createFeed(feedInfo);

        var request = new DeleteRequest()
                .withSelectionCriteria(
                        new FeedsSelectionCriteria()
                                .withIds(feedInfo.getFeedId()));
        ApiClient apiClient = api.userSteps().feedSteps().defaultClientV5();
        String clientLogin = roleRelationInfo.getOwnerUserInfo().getLogin();

        Object result;
        try {
            DeleteResponse response = apiClient.invokeMethod(FEEDS, clientLogin, DELETE, request);
            result = "size=" + response.getDeleteResults().size();
        } catch (Exception ex) {
            result = ex.getMessage();
        }
        assertThat(result).as("Результат").isEqualTo(expectedResult);
    }

}
