package ru.yandex.autotests.direct.api.keywordsresearch.deduplicate;

import com.yandex.direct.api.v5.keywordsresearch.DeduplicateResponse;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.keywordsresearch.KeywordsResearchFeatures;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.DeduplicateRequestItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.DeduplicateRequestMap;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.rbac.RbacRole;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Features(KeywordsResearchFeatures.CHECK_LOGIN_POSSIBLE)
@Description("Тест на возможность доступа к ручке KeywordsResearch.deduplicate с указанием/без указания client-login")
public class CanLoginAgencyClientPositiveTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @Test
    public void loginPossible_Client_Test() {
        ClientInfo client = api.coreSteps().clientSteps().createDefaultClientWithRole(RbacRole.CLIENT);
        assertLoginPossible(client, null);
    }

    @Test
    public void loginPossible_Agency_Test() {
        ClientInfo agency = api.coreSteps().clientSteps().createDefaultClientWithRole(RbacRole.AGENCY);
        assertLoginPossible(agency, null);
    }

    @Test
    public void loginPossible_AgencyAndSubClient_Test() {
        ClientInfo agency = api.coreSteps().clientSteps().createDefaultClientWithRole(RbacRole.AGENCY);
        ClientInfo subClient = api.coreSteps().clientSteps().createDefaultClientUnderAgency(agency);
        assertLoginPossible(agency, subClient.getLogin());
    }

    private void assertLoginPossible(ClientInfo authClient, String apiLogin) {
        DeduplicateRequestMap requestMap = prepareRequest();
        DeduplicateResponse response = api
                .as(authClient)
                .userSteps
                .keywordsResearchSteps()
                .keywordsResearchDeduplicateRawResponse(requestMap, apiLogin);
        assertThat("ответ из сервиса получен", response.getAdd(),
                hasSize(1));
    }

    private DeduplicateRequestMap prepareRequest() {
        return new DeduplicateRequestMap()
                .withKeywords(new DeduplicateRequestItemMap().withKeyword("ключевая фраза"));
    }
}
