package ru.yandex.autotests.direct.api.keywordsresearch.hassearchvolume;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import ru.yandex.autotests.direct.api.keywordsresearch.KeywordsResearchFeatures;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.HasSearchVolumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.HasSearchVolumeSelectionCriteriaMap;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.autotests.directapi.steps.KeywordsResearchSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.rbac.RbacRole;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN;

@Features(KeywordsResearchFeatures.CHECK_LOGIN_POSSIBLE)
@Description("Негативный тест на возможность доступа к ручке KeywordsResearch.hasSearchVolume")
public class CanLoginAgencyClientNegativeTest {
    private static final List<String> keywords = Arrays.asList("носки", "брюки");
    @ClassRule
    public static final ApiSteps api = new ApiSteps();
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void loginNotPossible_ClientAndSubClient_Test() {
        ClientInfo agency = api.coreSteps().clientSteps().createDefaultClientWithRole(RbacRole.AGENCY);
        ClientInfo client = api.coreSteps().clientSteps().createDefaultClientWithRole(RbacRole.CLIENT);
        ClientInfo subClient = api.coreSteps().clientSteps().createDefaultClientUnderAgency(agency);
        assertLoginNotPossible(client, subClient);
    }

    @Test
    public void loginNotPossible_ClientAndAgency_Test() {
        ClientInfo client = api.coreSteps().clientSteps().createDefaultClientWithRole(RbacRole.CLIENT);
        ClientInfo agency = api.coreSteps().clientSteps().createDefaultClientWithRole(RbacRole.AGENCY);
        assertLoginNotPossible(client, agency);
    }

    @Test
    public void loginNotPossible_AgencyAndAgency_Test() {
        ClientInfo agency1 = api.coreSteps().clientSteps().createDefaultClientWithRole(RbacRole.AGENCY);
        ClientInfo agency2 = api.coreSteps().clientSteps().createDefaultClientWithRole(RbacRole.AGENCY);
        assertLoginNotPossible(agency1, agency2);
    }

    @Test
    public void loginNotPossible_AgencyAndClient_Test() {
        ClientInfo agency = api.coreSteps().clientSteps().createDefaultClientWithRole(RbacRole.AGENCY);
        ClientInfo client = api.coreSteps().clientSteps().createDefaultClientWithRole(RbacRole.CLIENT);
        assertLoginNotPossible(agency, client);
    }

    private void assertLoginNotPossible(ClientInfo authClient, ClientInfo apiClient) {
        KeywordsResearchSteps keywordsResearchSteps = api.as(authClient).userSteps.keywordsResearchSteps();
        thrown.expect(keywordsResearchSteps.getApi5JsonErrorMatcher(8800, UNKNOWN_LOGIN_IN_CLIENT_LOGIN));
        keywordsResearchSteps.keywordsResearchHasSearchVolumeRawResponse(prepareRequest(), apiClient.getLogin());
    }

    private HasSearchVolumeRequestMap prepareRequest() {
        return new HasSearchVolumeRequestMap()
                .withSelectionCriteria(new HasSearchVolumeSelectionCriteriaMap()
                        .withKeywords(keywords)
                        .withRegionIds(0L))
                .withFieldNames(HasSearchVolumeFieldEnum.KEYWORD, HasSearchVolumeFieldEnum.ALL_DEVICES);
    }
}
