package ru.yandex.autotests.direct.api.keywordsresearch.hassearchvolume;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum;
import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeResponse;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.keywordsresearch.KeywordsResearchFeatures;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.HasSearchVolumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.HasSearchVolumeSelectionCriteriaMap;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.rbac.RbacRole;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Features(KeywordsResearchFeatures.CHECK_LOGIN_POSSIBLE)
@Description("Тест на возможность доступа к ручке KeywordsResearch.hasSearchVolume с указанием/без указания client-login")
public class CanLoginAgencyClientPositiveTest {
    private static final List<String> keywords = Arrays.asList("носки", "брюки");

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @Test
    public void loginPossible_Client_Test() {
        ClientInfo client = api.coreSteps().clientSteps().createDefaultClientWithRole(RbacRole.CLIENT);
        assertLoginPossible(client, null);
    }

    @Test
    public void loginPossible_Agency_Test() {
        ClientInfo agency = api.coreSteps().clientSteps().createDefaultClientWithRole(RbacRole.AGENCY);
        assertLoginPossible(agency, null);
    }

    @Test
    public void loginPossible_AgencyAndSubClient_Test() {
        ClientInfo agency = api.coreSteps().clientSteps().createDefaultClientWithRole(RbacRole.AGENCY);
        ClientInfo subClient = api.coreSteps().clientSteps().createDefaultClientUnderAgency(agency);
        assertLoginPossible(agency, subClient.getLogin());
    }

    private void assertLoginPossible(ClientInfo authClient, String apiLogin) {
        HasSearchVolumeRequestMap requestMap = prepareRequest();
        HasSearchVolumeResponse response = api
                .as(authClient)
                .userSteps
                .keywordsResearchSteps()
                .keywordsResearchHasSearchVolumeRawResponse(requestMap, apiLogin);
        assertThat("ответ из сервиса получен", response.getHasSearchVolumeResults(),
                hasSize(keywords.size()));
    }

    private HasSearchVolumeRequestMap prepareRequest() {
        return new HasSearchVolumeRequestMap()
                .withSelectionCriteria(new HasSearchVolumeSelectionCriteriaMap()
                        .withKeywords(keywords)
                        .withRegionIds(0L))
                .withFieldNames(HasSearchVolumeFieldEnum.KEYWORD, HasSearchVolumeFieldEnum.ALL_DEVICES);
    }
}
