package ru.yandex.autotests.direct.api.keywordsresearch.hassearchvolume;

import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.keywordsresearch.KeywordsResearchFeatures;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.HasSearchVolumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.HasSearchVolumeSelectionCriteriaMap;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.ALL_DEVICES;
import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.DESKTOPS;
import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.KEYWORD;
import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.MOBILE_PHONES;
import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.TABLETS;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Features(KeywordsResearchFeatures.HAS_SEARCH_VOLUME)
@Description("Тест на общую корректность работы сервиса")
public class HasSearchVolumeSmokeTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @Test
    public void smokeTest() {
        HasSearchVolumeRequestMap request = new HasSearchVolumeRequestMap()
                .withSelectionCriteria(new HasSearchVolumeSelectionCriteriaMap()
                        .withKeywords("носки", "брюки")
                        .withRegionIds(0L))
                .withFieldNames(KEYWORD, ALL_DEVICES);
        HasSearchVolumeResponse response =
                api.userSteps.keywordsResearchSteps().keywordsResearchHasSearchVolumeRawResponse(request);
        assertThat("ответ из сервиса получен", response.getHasSearchVolumeResults(),
                hasSize(2));
    }

    @BeforeClass
    public static void init() {
        ClientInfo clientInfo = api.createClient();
        api.as(clientInfo);
    }

    @Test
    public void correctKeywordsTest() {
        HasSearchVolumeRequestMap request = new HasSearchVolumeRequestMap()
                .withSelectionCriteria(new HasSearchVolumeSelectionCriteriaMap()
                        .withKeywords(
                                "муфельная -печь",
                                "Нью-Йорк",
                                "\"жк барская усадьба\"")
                        .withRegionIds(0L))
                .withFieldNames(KEYWORD, DESKTOPS, MOBILE_PHONES, TABLETS, ALL_DEVICES);

        HasSearchVolumeResponse response =
                api.userSteps.keywordsResearchSteps().keywordsResearchHasSearchVolumeRawResponse(request);
        assertThat("все ответы получены", response.getHasSearchVolumeResults().size(), equalTo(3));
    }

    @Test
    public void keywordsWithLeadingSpacesInRequestTest() {
        HasSearchVolumeRequestMap request = new HasSearchVolumeRequestMap()
                .withSelectionCriteria(new HasSearchVolumeSelectionCriteriaMap()
                        .withKeywords(" тмф ")
                        .withRegionIds(0L))
                .withFieldNames(ALL_DEVICES);

        HasSearchVolumeResponse response =
                api.userSteps.keywordsResearchSteps().keywordsResearchHasSearchVolumeRawResponse(request);
        assertThat("все ответы получены", response.getHasSearchVolumeResults().size(), equalTo(1));
    }

}
