package ru.yandex.autotests.direct.api.smartadtargets;

import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.smartadtargets.DeleteRequest;
import com.yandex.direct.api.v5.smartadtargets.SmartAdTargetGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonError;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.autotests.directapi.steps.PerformanceFilterSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.core.testing.info.PerformanceFilterInfo;
import ru.yandex.qatools.allure.annotations.Features;

import static org.assertj.core.api.Assertions.assertThat;

@Features(SmartAdTargetsFeatures.DELETE)
public class DeleteSmartAdTargetsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();
    private static PerformanceFilterSteps performanceFilterSteps;
    private static Long perfFilterId;

    @BeforeClass
    public static void init() {
        ClientInfo clientInfo = api.createClient();
        api.as(clientInfo);

        performanceFilterSteps = api.userSteps().performanceFilterSteps();
        PerformanceFilterInfo startFilterInfo = performanceFilterSteps.addDefaultPerformanceFilter(clientInfo);
        perfFilterId = startFilterInfo.getFilterId();
    }

    @Test
    public void deleteSmartAdTarget_success() {
        DeleteRequest deleteRequest = TestSmartAdTargets.createDeleteRequest(perfFilterId);
        performanceFilterSteps.shouldGetResultOnDeleteRequest(
                deleteRequest,
                ExpectedResult.success(perfFilterId));

        SmartAdTargetGetItem actualItem = performanceFilterSteps.getSmartAdTargetGetItem(perfFilterId);
        assertThat(actualItem.getState()).as("Expected state")
                .isEqualTo(StateEnum.DELETED);
    }

    @Test
    public void deleteSmartAdTarget_withNotExistFilterId_emptyResult() {
        long notExistPerfFilterId = Integer.MAX_VALUE - 1L;
        DeleteRequest deleteRequest = TestSmartAdTargets.createDeleteRequest(notExistPerfFilterId);
        performanceFilterSteps.shouldGetResultOnDeleteRequest(
                deleteRequest,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.NULL)));
    }

    @Test
    public void deleteSmartAdTarget_withSomebodyElseFilterId_emptyResult() {
        PerformanceFilterInfo somebodyElseFilterInfo = performanceFilterSteps.createDefaultPerformanceFilter();
        DeleteRequest deleteRequest = TestSmartAdTargets.createDeleteRequest(somebodyElseFilterInfo.getFilterId());
        performanceFilterSteps.shouldGetResultOnDeleteRequest(
                deleteRequest,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)));
    }

    @Test(expected = Api5JsonError.class)
    public void deleteSmartAdTarget_withEmptyRequest_failure() {
        DeleteRequest deleteRequest = new DeleteRequest();
        performanceFilterSteps.sendDeleteRequest(deleteRequest);
    }

}
