package ru.yandex.autotests.direct.api.smartadtargets;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.general.AdTargetsSelectionCriteria;
import com.yandex.direct.api.v5.smartadtargets.GetRequest;
import com.yandex.direct.api.v5.smartadtargets.GetResponse;
import com.yandex.direct.api.v5.smartadtargets.SmartAdTargetFieldEnum;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.directapi.apiclient.ApiClient;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.data.TestRoleRelation;
import ru.yandex.direct.core.testing.info.PerformanceAdGroupInfo;
import ru.yandex.direct.core.testing.info.PerformanceFilterInfo;
import ru.yandex.direct.core.testing.info.RoleRelationInfo;
import ru.yandex.qatools.allure.annotations.Features;

import static org.assertj.core.api.Assertions.assertThat;
import static ru.yandex.autotests.directapi.model.api5.Action.GET;
import static ru.yandex.autotests.directapi.model.api5.ServiceNames.SMART_AD_TARGETS;


@Features(SmartAdTargetsFeatures.GET)
@RunWith(Parameterized.class)
public class GetSmartAdTargetsByRolesTest {
    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(1)
    public TestRoleRelation roleRelation;

    @Parameterized.Parameter(2)
    public Object expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static List<Object[]> testData() {
        Object[][] data = new Object[][]{
                {"Тот же клиент", TestRoleRelation.CLIENT_CHIEF_AND_SAME_CLIENT, "size=1"},
                {"Посторонний клиент", TestRoleRelation.CLIENT_AND_OTHER_CLIENT, "Объект не найден"},
                {"Агенство и клиент", TestRoleRelation.AGENCY_AND_SUB_CLIENT, "size=1"},
                {"IDM менеджер и клиент", TestRoleRelation.IDM_MANAGER_AND_CLIENT, "size=1"},
                {"Менеджер и его клиент", TestRoleRelation.CLIENT_MANAGER_AND_CLIENT, "size=1"},
                {"Представитель клиента", TestRoleRelation.REP_AND_CHIEF, "size=1"},
                {"Суперпользователь", TestRoleRelation.SUPER_AND_CLIENT, "size=1"},
                {"Суперриадер", TestRoleRelation.SUPER_READER_AND_CLIENT, "size=1"},
                {"Саппорт", TestRoleRelation.SUPPORT_AND_CLIENT, "size=1"},
        };
        return Arrays.asList(data);
    }

    @Test
    public void get() {
        ApiSteps api = new ApiSteps();
        RoleRelationInfo roleRelationInfo = api.coreSteps().rolesSteps().getRoleRelationInfo(roleRelation);
        api.as(roleRelationInfo.getOperatorUserInfo().getUser());


        PerformanceAdGroupInfo adGroupInfo =
                api.coreSteps().adGroupSteps().createDefaultPerformanceAdGroup(roleRelationInfo.getOwnerClientInfo());
        if (roleRelation == TestRoleRelation.CLIENT_MANAGER_AND_CLIENT) {
            api.coreSteps().campaignSteps()
                    .setManager(adGroupInfo.getCampaignInfo(), roleRelationInfo.getOperatorUserInfo().getUid());
        } else if (roleRelation == TestRoleRelation.AGENCY_AND_SUB_CLIENT) {
            api.coreSteps().campaignSteps()
                    .setAgency(adGroupInfo.getCampaignInfo(),
                            roleRelationInfo.getOperatorUserInfo().getClientId(),
                            roleRelationInfo.getOperatorUserInfo().getUid());
        }
        PerformanceFilterInfo filterInfo =
                api.coreSteps().performanceFilterSteps()
                        .addPerformanceFilter(new PerformanceFilterInfo().withAdGroupInfo(adGroupInfo));
        GetRequest request = new GetRequest()
                .withFieldNames(SmartAdTargetFieldEnum.ID)
                .withSelectionCriteria(new AdTargetsSelectionCriteria().withIds(filterInfo.getFilterId()));
        ApiClient apiClient = api.userSteps().performanceFilterSteps().defaultClientV5();
        String clientLogin = roleRelationInfo.getOwnerUserInfo().getLogin();

        Object result;
        try {
            GetResponse response = apiClient.invokeMethod(SMART_AD_TARGETS, clientLogin, GET, request);
            result = "size=" + response.getSmartAdTargets().size();
        } catch (Exception ex) {
            result = ex.getMessage();
        }
        assertThat(result).as("Результат").isEqualTo(expectedResult);
    }

}
