package ru.yandex.autotests.direct.api.smartadtargets;

import com.yandex.direct.api.v5.smartadtargets.SetBidsRequest;
import com.yandex.direct.api.v5.smartadtargets.SmartAdTargetGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonError;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.autotests.directapi.steps.PerformanceFilterSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.core.testing.info.PerformanceFilterInfo;
import ru.yandex.qatools.allure.annotations.Features;

import static org.assertj.core.api.Assertions.assertThat;
import static ru.yandex.autotests.direct.api.smartadtargets.TestSmartAdTargets.DEFAULT_NEW_CPA_PRICE;
import static ru.yandex.direct.api.v5.entity.smartadtargets.converter.CommonConverters.FACTORY;

@Features(SmartAdTargetsFeatures.SET_BIDS)
public class SetBidsSmartAdTargetsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();
    private static PerformanceFilterSteps performanceFilterSteps;
    private static Long perfFilterId;

    @BeforeClass
    public static void init() {
        ClientInfo clientInfo = api.createClient();
        api.as(clientInfo);

        performanceFilterSteps = api.userSteps().performanceFilterSteps();
        PerformanceFilterInfo startFilterInfo = performanceFilterSteps.addDefaultPerformanceFilter(clientInfo);
        perfFilterId = startFilterInfo.getFilterId();
    }

    @Test
    public void setBidsSmartAdTarget_success() {
        SetBidsRequest setBidsRequest = TestSmartAdTargets.createDefaultSetBidsRequest(perfFilterId);
        performanceFilterSteps.shouldGetResultOnSetBidsRequest(setBidsRequest, ExpectedResult.success(perfFilterId));

        SmartAdTargetGetItem actualItem =  performanceFilterSteps.getSmartAdTargetGetItem(perfFilterId);
        long expectedCpaPrice = DEFAULT_NEW_CPA_PRICE * 1_000_000L;
        assertThat(actualItem.getAverageCpa().getValue()).as("New Cpa price").isEqualTo(expectedCpaPrice);
    }

    @Test
    public void setBidsSmartAdTarget_withWrongPriceCpa_failure() {
        long tooBigPrice = Integer.MAX_VALUE - 1L;
        SetBidsRequest setBidsRequest = TestSmartAdTargets.createDefaultSetBidsRequest(perfFilterId);
        setBidsRequest.getBids().get(0).withAverageCpa(FACTORY.createSetBidsItemAverageCpa(tooBigPrice * 1_000_000L));

        performanceFilterSteps.shouldGetResultOnSetBidsRequest(
                setBidsRequest,
                ExpectedResult.errors(
                        new Notification(5005, Api5ErrorDetails.INVALID_VALUE_SHORT, "AverageCpa", tooBigPrice)));
    }

    @Test(expected = Api5JsonError.class)
    public void setBidsSmartAdTarget_withEmptyRequest_failure() {
        SetBidsRequest setBidsRequest = new SetBidsRequest();
        performanceFilterSteps.sendSetBidsRequest(setBidsRequest);
    }

}
