package ru.yandex.autotests.direct.api.smartadtargets;

import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.smartadtargets.SmartAdTargetGetItem;
import com.yandex.direct.api.v5.smartadtargets.SuspendRequest;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonError;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.autotests.directapi.steps.PerformanceFilterSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.core.testing.info.PerformanceFilterInfo;
import ru.yandex.qatools.allure.annotations.Features;

import static org.assertj.core.api.Assertions.assertThat;

@Features(SmartAdTargetsFeatures.SUSPEND)
public class SuspendSmartAdTargetsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();
    private static PerformanceFilterSteps performanceFilterSteps;
    private static Long perfFilterId;

    @BeforeClass
    public static void init() {
        ClientInfo clientInfo = api.createClient();
        api.as(clientInfo);

        performanceFilterSteps = api.userSteps().performanceFilterSteps();
        PerformanceFilterInfo startFilterInfo = performanceFilterSteps.addDefaultPerformanceFilter(clientInfo);
        perfFilterId = startFilterInfo.getFilterId();
    }

    @Test
    public void suspendSmartAdTarget_success() {
        SuspendRequest suspendRequest = TestSmartAdTargets.createSuspendRequest(perfFilterId);
        performanceFilterSteps.shouldGetResultOnSuspendRequest(
                suspendRequest,
                ExpectedResult.success(perfFilterId));

        SmartAdTargetGetItem actualItem = performanceFilterSteps.getSmartAdTargetGetItem(perfFilterId);
        assertThat(actualItem.getState()).as("Expected state")
                .isEqualTo(StateEnum.SUSPENDED);
    }

    @Test
    public void suspendSmartAdTarget_withNotExistFilterId_emptyResult() {
        long notExistPerfFilterId = Integer.MAX_VALUE - 1L;
        SuspendRequest suspendRequest = TestSmartAdTargets.createSuspendRequest(notExistPerfFilterId);
        performanceFilterSteps.shouldGetResultOnSuspendRequest(
                suspendRequest,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.NULL)));
    }

    @Test
    public void suspendSmartAdTarget_withSomebodyElseFilterId_emptyResult() {
        PerformanceFilterInfo somebodyElseFilterInfo = performanceFilterSteps.createDefaultPerformanceFilter();
        SuspendRequest suspendRequest = TestSmartAdTargets.createSuspendRequest(somebodyElseFilterInfo.getFilterId());
        performanceFilterSteps.shouldGetResultOnSuspendRequest(
                suspendRequest,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)));
    }

    @Test(expected = Api5JsonError.class)
    public void suspendSmartAdTarget_withEmptyRequest_failure() {
        SuspendRequest suspendRequest = new SuspendRequest();
        performanceFilterSteps.sendSuspendRequest(suspendRequest);
    }

}
