package ru.yandex.autotests.direct.api.smartadtargets;

import com.yandex.direct.api.v5.general.AdTargetsSelectionCriteria;
import com.yandex.direct.api.v5.general.ConditionTypeEnum;
import com.yandex.direct.api.v5.general.IdsCriteria;
import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.smartadtargets.AddRequest;
import com.yandex.direct.api.v5.smartadtargets.AudienceEnum;
import com.yandex.direct.api.v5.smartadtargets.ConditionsArray;
import com.yandex.direct.api.v5.smartadtargets.ConditionsItem;
import com.yandex.direct.api.v5.smartadtargets.DeleteRequest;
import com.yandex.direct.api.v5.smartadtargets.GetRequest;
import com.yandex.direct.api.v5.smartadtargets.ResumeRequest;
import com.yandex.direct.api.v5.smartadtargets.SetBidsRequest;
import com.yandex.direct.api.v5.smartadtargets.SmartAdTargetFieldEnum;
import com.yandex.direct.api.v5.smartadtargets.SmartAdTargetGetItem;
import com.yandex.direct.api.v5.smartadtargets.SuspendRequest;
import com.yandex.direct.api.v5.smartadtargets.UpdateRequest;

import static java.util.Collections.singleton;
import static ru.yandex.direct.api.v5.entity.smartadtargets.converter.CommonConverters.FACTORY;

public class TestSmartAdTargets {

    static final String DEFAULT_NEW_NAME = "new test perf filter";
    static final long DEFAULT_NEW_CPA_PRICE = 44L;
    private static final String DEFAULT_NAME = "test perf filter";
    private static final long DEFAULT_CPA_PRICE = 33L;
    private static final long DEFAULT_CPC_PRICE = 22L;

    private static final String DEFAULT_OPERAND = "price";
    private static final String DEFAULT_RANGE_1 = "3000.00-100000.00";
    private static final String DEFAULT_RANGE_2 = "111.00-222.00";

    private static final String OTHER_OPERAND = "model";
    private static final StringConditionOperatorEnum OTHER_OPERATION = StringConditionOperatorEnum.CONTAINS_ANY;
    private static final String OTHER_VALUE1 = "ggg";
    private static final String OTHER_VALUE2 = "www";

    private static final PriorityEnum DEFAULT_STRATEGY_PRIORITY = null;
    private static final AudienceEnum DEFAULT_AUDIENCE = AudienceEnum.VISITED_PRODUCT_PAGE;
    private static final YesNoEnum DEF_AVAILABLE_ONLY = YesNoEnum.YES;

    static AddRequest createDefaultAddRequest(long adGroupId) {
        return FACTORY.createAddRequest()
                .withSmartAdTargets(FACTORY.createSmartAdTargetAddItem()
                        .withAdGroupId(adGroupId)
                        .withName(DEFAULT_NAME)
                        .withAverageCpc(DEFAULT_CPC_PRICE * 1_000_000L)
                        .withAverageCpa(DEFAULT_CPA_PRICE * 1_000_000L)
                        .withAudience(DEFAULT_AUDIENCE)
                        .withAvailableItemsOnly(DEF_AVAILABLE_ONLY)
                        .withStrategyPriority(DEFAULT_STRATEGY_PRIORITY)
                        .withConditions(defaultConditions()));
    }

    static SmartAdTargetGetItem createDefaultGetItemWithoutConditions(Long perfFilterId, Long adGroupId,
                                                                      Long campaignId) {
        return FACTORY.createSmartAdTargetGetItem()
                .withId(perfFilterId)
                .withAdGroupId(adGroupId)
                .withName(DEFAULT_NAME)
                .withAverageCpc(FACTORY.createSmartAdTargetGetItemAverageCpc(DEFAULT_CPC_PRICE * 1_000_000L))
                .withAverageCpa(FACTORY.createSmartAdTargetGetItemAverageCpa(DEFAULT_CPA_PRICE * 1_000_000L))
                .withAudience(DEFAULT_AUDIENCE)
                .withAvailableItemsOnly(FACTORY.createSmartAdTargetGetItemAvailableItemsOnly(DEF_AVAILABLE_ONLY))
                .withConditionType(ConditionTypeEnum.ITEMS_SUBSET)
                .withCampaignId(campaignId)
                .withState(StateEnum.OFF)
                .withStrategyPriority(FACTORY.createSmartAdTargetGetItemStrategyPriority(DEFAULT_STRATEGY_PRIORITY));
    }

    static ConditionsArray defaultConditions() {
        return FACTORY.createConditionsArray()
                .withItems(new ConditionsItem()
                        .withOperand(DEFAULT_OPERAND)
                        .withOperator(StringConditionOperatorEnum.IN_RANGE)
                        .withArguments(DEFAULT_RANGE_1, DEFAULT_RANGE_2));
    }

    static ConditionsArray otherConditions() {
        return FACTORY.createConditionsArray()
                .withItems(new ConditionsItem()
                        .withOperand(OTHER_OPERAND)
                        .withOperator(OTHER_OPERATION)
                        .withArguments(OTHER_VALUE1, OTHER_VALUE2));
    }

    static GetRequest createGetRequest(Long perfFilterId) {
        return FACTORY.createGetRequest()
                .withSelectionCriteria(
                        new AdTargetsSelectionCriteria()
                                .withIds(singleton(perfFilterId)))
                .withFieldNames(SmartAdTargetFieldEnum.values());
    }

    static UpdateRequest createDefaultUpdateRequest(Long perfFilterId) {
        return FACTORY.createUpdateRequest()
                .withSmartAdTargets(
                        FACTORY.createSmartAdTargetUpdateItem()
                                .withId(perfFilterId)
                                .withName(DEFAULT_NEW_NAME)
                                .withAverageCpa(
                                        FACTORY.createSmartAdTargetUpdateItemAverageCpa(DEFAULT_NEW_CPA_PRICE * 1_000_000L)));
    }

    static UpdateRequest createConditionsUpdateRequest(Long perfFilterId) {
        return FACTORY.createUpdateRequest()
                .withSmartAdTargets(
                        FACTORY.createSmartAdTargetUpdateItem()
                                .withId(perfFilterId)
                                .withConditions(FACTORY.createSmartAdTargetUpdateItemConditions(otherConditions()))
                                .withAvailableItemsOnly(YesNoEnum.NO));
    }

    static DeleteRequest createDeleteRequest(Long perfFilterId) {
        return FACTORY.createDeleteRequest()
                .withSelectionCriteria(
                        new IdsCriteria()
                                .withIds(singleton(perfFilterId)));
    }

    static SuspendRequest createSuspendRequest(Long perfFilterId) {
        return FACTORY.createSuspendRequest()
                .withSelectionCriteria(
                        new IdsCriteria()
                                .withIds(singleton(perfFilterId)));
    }

    static ResumeRequest createResumeRequest(Long perfFilterId) {
        return FACTORY.createResumeRequest()
                .withSelectionCriteria(
                        new IdsCriteria()
                                .withIds(singleton(perfFilterId)));
    }

    static SetBidsRequest createDefaultSetBidsRequest(Long perfFilterId) {
        return FACTORY.createSetBidsRequest()
                .withBids(
                        FACTORY.createSetBidsItem()
                                .withAverageCpa(FACTORY.createSetBidsItemAverageCpa(DEFAULT_NEW_CPA_PRICE * 1_000_000L))
                                .withId(perfFilterId));
    }
}

