package ru.yandex.autotests.direct.utils;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.RandomUtils;

import ru.yandex.autotests.direct.utils.textresource.DirectUtilsException;

public class PhraseTexts {
    private static String[] texts =
            new String[]{"купить iphone в рассрочку", "автомобили с пробегом", "елочные игрушки",
                    "тестирование крокодилов", "нудистские пляжи", "иосиф кобзон", "харакири в домашних условиях",
                    "пингвины социопаты", "тестировщики директа лучшие", "превращение воды в вино",
                    "стрижки для тараканов", "бои хомяков", "сажать картофель страусом", "летные характеристики киви",
                    "битва на ложках", "бритье топором", "анонимные аутофобы", "гомоморфный образ группы",
                    "самоучитель русского мата", "зарядить айфон в микроволновке", "котята шредингера купить",
                    "рязань лозохождение", "наручные атомные часы", "лабрадоры плейстоцена",
                    "варить клейстер всей семьей", "спектрохроматография по скайпу", "козни в детском саду",
                    "рогатка из вешалки", "липосакция КНДР срочно", "народная медицина щавель",
                    "монстры под кроватью классификация", "отец братьев пилотов", "тунгусский планетарий",
                    "многоразовые летчики", "экспресс-метод Анны Карениной", "ядра чистый изумруд", "однорукие бандиты",
                    "яркая котлета", "бульдозеры и болотоходы с доставкой", "продукт готовый к злоупотреблению",
                    "кузькина мать зовет", "базар копейку любит", "тестирование виски", "однорогий заяц",
                    "счастливый блокнот", "драники в сметане", "срочно продам волосы", "ромашковый чай", "бюро находок",
                    "пакет с весной", "спортивные вещи", "мастер фломастер", "ништяки для грызунов",
                    "комната на петроградке", "потеряшка в офисе"};
    private int counter = 0;

    public PhraseTexts() {
    }

    public static String getRandom() {
        return texts[RandomUtils.nextInt(0, texts.length)];
    }

    public static String[] getTexts(int i) {
        if (i > texts.length) {
            throw new DirectUtilsException("Кончились доступные тексты фраз");
        } else {
            PhraseTexts phraseTexts = new PhraseTexts();
            List<String> texts = new ArrayList<>();

            for (int j = 0; j < i; ++j) {
                texts.add(phraseTexts.getNext());
            }

            return texts.toArray(new String[0]);
        }
    }

    public String getNext() {
        if (this.counter >= texts.length) {
            throw new DirectUtilsException("Кончились доступные тексты фраз");
        } else {
            String phraseText = texts[this.counter];
            ++this.counter;
            return phraseText;
        }
    }
}
