package ru.yandex.autotests.direct.utils.differs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import javax.xml.bind.JAXBElement;

import ru.yandex.autotests.irt.testutils.beandiffer2.Diff;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.AbstractDiffer;

public class JAXBElementDiffer extends AbstractDiffer {
    @Override
    public List<Diff> compare(Object actual, Object expected) {
        List<Diff> result = new ArrayList<>();
        JAXBElement actualJ = (JAXBElement) actual;
        JAXBElement expectedJ = (JAXBElement) expected;
        if ((actualJ == null || actualJ.isNil()) && (expectedJ == null || expectedJ.isNil())) {
            return result;
        }
        if (actualJ == null || actualJ.isNil() || expectedJ == null || expectedJ.isNil()) {
            result.add(Diff.changed(getField(), actual, expected));
            return result;
        }
        Object actualValue = actualJ.getValue();
        Object expectedValue = expectedJ.getValue();
        if (!Objects.equals(actualValue, expectedValue)) {
            result.add(Diff.changed(getField(), actualValue, expectedValue));
        }
        return result;
    }
}
