package ru.yandex.autotests.direct.utils.textresource;

import java.util.List;

import ru.yandex.autotests.directapi.apiclient.config.ApiLocale;
import ru.yandex.direct.i18n.Translatable;

/**
 * Created with IntelliJ IDEA.
 * User: alexey-n
 */

public interface ITextResource {

    String getBundle();

    String name();

    Translatable getTranslatable(List<Object> params);

    default String getErrorText() {
        return getErrorText(ApiLocale.RU.toString());
    }

    default String getErrorText(String locale) {
        return TextResourceFormatter.resource(this).locale(locale).toString();
    }
}
