package ru.yandex.autotests.direct.utils.textresource;

import static ru.yandex.autotests.direct.utils.textresource.TextResources.getText;

/**
 * Created with IntelliJ IDEA.
 * User: alexey-n
 */
public class TextResourceFormatter {
    private Object[] formatParams;
    private String locale = "en";
    private ITextResource textResource;

    private TextResourceFormatter(ITextResource resource) {
        this.textResource = resource;
    }

    public static TextResourceFormatter resource(ITextResource resource) {
        return new TextResourceFormatter(resource);
    }

    public ITextResource getTextResource() {
        return textResource;
    }

    public TextResourceFormatter args(Object... formatParams) {
        this.formatParams = formatParams;
        return this;
    }

    public TextResourceFormatter locale(String locale) {
        this.locale = locale;
        return this;
    }

    @Override
    public String toString() {
        String text;
        text = getText(textResource, locale, true);
        if (formatParams != null) {
            text = String.format(text, formatParams);
        }
        return text;
    }
}
