package ru.yandex.autotests.directapi.apiclient;

import java.util.Map;
import java.util.stream.Collectors;

import javax.ws.rs.core.Response;

public class HttpMessage {
    private String url;
    private String headers;
    private Map<String, String> headerMap;
    private String request;
    private String responseHeaders;

    public Map<String, String> getResponseHeaderMap() {
        return responseHeaderMap;
    }

    public void setResponseHeaderMap(Map<String, String> responseHeaderMap) {
        this.responseHeaderMap = responseHeaderMap;
    }

    private Map<String, String> responseHeaderMap;
    private String response;
    private String statusCode;


    public void setUrl(String url) {
        this.url = url;
    }

    @Deprecated
    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public void setHeaderMap(Map<String, Object> headerMap) {
        this.headerMap = headerMap.entrySet().stream()
                .collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
        this.headers = this.headerMap.toString();
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public void setResponseHeaders(String responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public Response.Status getStatus() {
        return Response.Status.fromStatusCode(Integer.parseInt(this.statusCode));
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getResponseHeaders() {
        return responseHeaders;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("URL: " + url);
        builder.append("\n");
        if (headers != null) {
            builder.append("HEADERS: " + headers);
            builder.append("\n");
        }
        builder.append("REQUEST: " + request.replaceAll("(\"RawData\":)([^,]+)", "$1\"<base64 data>\"")
                .replaceAll("(\"ImageData\": )(\".+\")", "$1\"<base64 data>\""));
        builder.append("\n");
        if (responseHeaders != null) {
            builder.append("HEADERS: " + responseHeaders);
            builder.append("\n");
        }
        builder.append("RESPONSE: " + response);
        builder.append("\n");
        builder.append("STATUS CODE: " + statusCode);
        return builder.toString();
    }

    private String headerMapToCurlOptions() {
        return this.headerMap.entrySet().stream()
                .map(entry -> String.format("-H \"%s: %s\"", entry.getKey(), entry.getValue()))
                .collect(Collectors.joining(" "));
    }

    private String headersToCurlOptions() {
        if (headerMap != null) {
            return headerMapToCurlOptions();
        } else {
            return ""; // might've happen in api4
        }
    }

    public String toCurlStringForSoap() {
        StringBuilder builder = new StringBuilder();
        builder.append("curl -k " + headersToCurlOptions() + " \\\n");
        builder.append("-d $'" + request.replaceAll("(\"RawData\":)([^,]+)", "$1\"<base64 data>\"")
                .replaceAll("(\"ImageData\": )(\".+\")", "$1\"<base64 data>\"")
                .replace("\'", "\\'"));
        builder.append("' \"" + url + "\"\n");
        return builder.toString();
    }

    public String toCurlStringForXml() {
        return String.format("curl -k %s -d \"%s\" %s", headerMapToCurlOptions(), request.replace("\"", "'"), url);
    }

    public String toCurlStringForJson() {
        StringBuilder builder = new StringBuilder();

        builder.append("curl -k " + headersToCurlOptions() + " \\\n");
        builder.append("-d '" + request.replaceAll("(\"RawData\":)([^,]+)", "$1\"<base64 data>\"")
                .replaceAll("(\"ImageData\": )(\".+\")", "$1\"<base64 data>\""));
        builder.append("' \"" + url + "\"\n");
        return builder.toString();
    }

    public String getResponse() {
        return response;
    }
}
