package ru.yandex.autotests.directapi.apiclient;

import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.directapi.apiclient.config.ApiLocale;
import ru.yandex.autotests.directapi.apiclient.internal.JsonUtils;

public class RequestHeader implements Cloneable {
    @SerializedName("application_id")
    private String applicationID = "ae99016820074f809e5c268e564bebad";

    @SerializedName("login")
    private String login;

    @SerializedName("locale")
    private String locale;

    @SerializedName("token")
    private String token;

    @SerializedName("finance_token")
    private String masterToken;

    @SerializedName("operation_num")
    private Long operationNumber;

    @SerializedName("payment_token")
    private String paymentToken;

    @SerializedName("fake_login")
    private String fakeLogin;

    @SerializedName("persistent_token")
    private String persistentToken;

    @SerializedName("use_operator_units")
    private String useOperatorUnits;

    @SerializedName("token_type")
    private String tokenType;

    @SerializedName("return_money_in_micros")
    private Boolean returnMoneyInMicros;

    @SerializedName("skip_report_header")
    private Boolean skipReportHeader;

    @SerializedName("skip_column_header")
    private Boolean skipColumnHeader;

    @SerializedName("skip_report_summary")
    private Boolean skipReportSummary;

    @SerializedName("client_login")
    private String clientLogin;

    /**
     * Используется в тестах на Changes.checkCampaigns (см. DIRECT-65187)
     */
    @SerializedName("useCampAggregatedLastChange")
    private Boolean useCampAggregatedLastChange;

    /**
     * Если задано, то для методов имеющих имплементацию в Perl и Java будет
     * выбран Perl (в конфиге nginx не будет перехода на бэк java и в perl не будет работать проксирование)
     */
    @SerializedName("prefer_perl_implementation")
    private Boolean preferPerlImplementation;

    public RequestHeader(String login, String token) {
        this.login = login;
        this.locale = ApiLocale.RU.toString();
        this.token = token;
    }

    public RequestHeader clone() {
        RequestHeader clone = JsonUtils.getObject(JsonUtils.toString(this), RequestHeader.class);
        return clone;
    }

    public String getLogin() {
        return login;
    }

    public String getLocale() {
        return locale;
    }

    public String getToken() {
        return token;
    }
}
