package ru.yandex.autotests.directapi.apiclient.errors;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.direct.api.v5.ApiFaultTranslations;
import ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectTranslations;
import ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectTranslations;
import ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectTranslations;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectTranslations;
import ru.yandex.direct.core.entity.feed.validation.FeedDefectTranslations;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.types.DummyTranslatable;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.validation.result.Path;

import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;
import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.validation.result.PathHelper.field;

public enum Api5ErrorDetails implements ITextResource {
    ADDITIONAL_METRICA_COUNTERS_INCORRECTLY_SPECIFIED(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    AD_CANNOT_ARCHIVE_DRAFT(BannerDefectTranslations.class, BannerDefectTranslations::cannotArchiveDraftBanner),
    AD_CANNOT_RESUME_DRAFT(BannerDefectTranslations.class, BannerDefectTranslations::cannotResumeDraftBanner),
    AD_CANNOT_SUSPEND_ARCHIVED(BannerDefectTranslations.class, BannerDefectTranslations::cannotSuspendArchivedBanner),
    AD_NOT_FOUND(BannerDefectTranslations.class, BannerDefectTranslations::adNotFoundDetailed),
    ALL_GOALS_OPTIMIZATION_IS_PROHIBITED(CampaignDefectTranslations.class,
            CampaignDefectTranslations::allGoalsOptimizationProhibited),
    AVERAGE_PRICE_SHOULD_BE_LESS_THAN(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    AVERAGE_PRICE_SHOULD_BE_MORE_THAN(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    BID_MODIFIER_MUST_BE_GREATER(BidModifiersDefectTranslations.class,
            (t, params) -> t.percentMustBeGreaterThanOrEqualToMin(getIdentityFromIntParam(params))),
    BID_MODIFIER_NOT_FOUND(BidModifiersDefectTranslations.class, BidModifiersDefectTranslations::notFoundDetailed),
    CAMPAIGN_NOT_FOUND(CommonDefectTranslations.class, CommonDefectTranslations::campaignNotFound),
    CAMPAIGN_SETTING_DEPRECATED(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    CREATIVE_NOT_FOUND(BannerDefectTranslations.class, (t, params) -> t.creativeNotFound()),
    ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    EMPTY_STRING(TranslationBundle.class, t -> translator -> ""),
    FEED_APART_RESET_LOGIN_AND_PASSWORD(FeedDefectTranslations.class,
            FeedDefectTranslations::feedApartResetLoginAnPasswordDetailed),
    FEED_BODY_FIELD_IS_TOO_LONG(FeedDefectTranslations.class,
            (t, params) -> t.feedBodyFieldIsTooLongDetailed(getIdentityFromIntParam(params))),
    FEED_EMPTY_NAME(FeedDefectTranslations.class, FeedDefectTranslations::feedNameCannotBeEmptyDetailed),
    FEED_INCONSISTENT_TYPE(FeedDefectTranslations.class, FeedDefectTranslations::feedInconsistentTypeDetailed),
    FEED_INVALID_FILENAME(FeedDefectTranslations.class, FeedDefectTranslations::feedInvalidFilenameDetailed),
    FEED_INVALID_HREF(FeedDefectTranslations.class, FeedDefectTranslations::feedInvalidHrefDetailed),
    FEED_LOGIN_IS_NOT_SET(FeedDefectTranslations.class, FeedDefectTranslations::feedLoginIsNotSetDetailed),
    FEED_NAME_FIELD_IS_TOO_LONG(FeedDefectTranslations.class,
            (t, params) -> t.feedNameFieldIsTooLongDetailed(getIdentityFromIntParam(params))),
    FEED_NOT_EXIST_AD_GROUP(AdGroupDefectTranslations.class,
            (t, params) -> t.feedNotExistDetailed(getIdentityFromLongParam(params))),
    FEED_PASSWORD_IS_NOT_SET(FeedDefectTranslations.class, FeedDefectTranslations::feedPasswordIsNotSetDetailed),
    FEED_STATUS_WRONG(FeedDefectTranslations.class, (t, params) -> t.feedStatusWrongDetailed(params.get(0).toString())),
    FEED_USED_IN_AD_GROUP(FeedDefectTranslations.class, FeedDefectTranslations::feedUsedInAdGroupDetailed),
    GROUP_NAME_CANNOT_BE_EMPTY_STRING(AdGroupDefectTranslations.class,
            AdGroupDefectTranslations::adGroupNameCantBeEmpty),
    GROUP_NOT_FOUND(AdGroupDefectTranslations.class, AdGroupDefectTranslations::notFoundDetailed),
    INCORRECT_USE_OF_BRACKETS_IN_MINUS_PHRASE(MinusPhraseDefectTranslations.class,
            (t, params) -> t.imbalancedSquareBracketsDetailedWithList(params.get(0).toString())),
    INVALID_VALUE_SHORT(CommonDefectTranslations.class,
            (t, params) -> t.invalidValueWithPathDetailed(new Path(singletonList(field(params.get(0).toString()))),
                    params.get(1))),
    MAX_BID_SHOULD_BE_LESS_THAN(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    MAX_BID_SHOULD_BE_MORE_THAN(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    MAX_CONVERSION_RATE_MEANINGFUL_GOALS_IS_NOT_SET(CampaignDefectTranslations.class,
            CampaignDefectTranslations::toOptimizeForMeaningfulGoalAtLeastOneGoalExceptEngagedSessionIsRequired),
    MULTIPLE_SEARCH_STRATEGY_PARAMS(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    NOT_SUITABLE_MEANINGFUL_GOALS(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    NO_EFFECT_WALLET_DAY_BUDGET(CampaignDefectTranslations.class,
            CampaignDefectTranslations::dayBudgetCanBeUsedWithManualStrategiesOnly),
    NO_MORE_MERTRICA_COUNTERS_CAN_BE_SPECIFIED(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    NULL(TranslationBundle.class, t -> translator -> null), // в т.ч. для DefectIds.OBJECT_NOT_FOUND : DIRECT-69374
    PAY_FOR_CONVERSIOIN_DOES_NOT_ALLOW_ALL_GOALS_OPTIMIZATION(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    PRIORITY_GOAL_ID_NOT_FOUND(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    PRIORITY_GOAL_VALUE_TOO_BIG(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    PRIORITY_GOAL_VALUE_TOO_SMALL(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    ROI_MEANINGFUL_GOALS_IS_NOT_SET(CampaignDefectTranslations.class,
            CampaignDefectTranslations::toOptimizeForMeaningfulGoalAtLeastOneGoalExceptEngagedSessionIsRequired),
    SEARCH_STRATEGY_NAME_MISMATCH_WITH_PARAMETERS(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    SPECIFIED_GOAL_NOT_FOUND(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    STRATEGY_ON_SEARCH_MUST_CONTAINS_SETTINGS(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP(BannerDefectTranslations.class,
            BannerDefectTranslations::inconsistentBannerTypeAndGroupTypeDetailed),
    UNKNOWN_LOGIN_IN_CLIENT_LOGIN(ApiFaultTranslations.class, ApiFaultTranslations::unknownLoginInClientLogin),
    WEEKLY_BUDGET_MUST_BE_GREATER_THAN_MAXIMUM_BID(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    WEEKLY_BUDGET_SHOULD_BE_GREATER_THAN_AVERAGE_PRICE(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    WEEKLY_LIMIT_IS_TOO_HIGH(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    WEEKLY_LIMIT_SHOULD_BE_MORE_THAN(CampaignDefectTranslations.class, Api5ErrorDetails::todo),
    ;

    private final Function<List<Object>, Translatable> translatableSupplier;

    <T extends TranslationBundle> Api5ErrorDetails(Class<T> bundleClass, Function<T, Translatable> textProducer) {
        T bundle = bundleClass.cast(I18NBundle.implement(bundleClass));
        translatableSupplier = params -> textProducer.apply(bundle);
    }

    <T extends TranslationBundle> Api5ErrorDetails(Class<T> bundleClass,
                                                   BiFunction<T, List<Object>, Translatable> textProducer) {
        T bundle = bundleClass.cast(I18NBundle.implement(bundleClass));
        translatableSupplier = params -> textProducer.apply(bundle, params);
    }

    private static Identity getIdentityFromLongParam(List<Object> params) {
        long id = Long.parseLong(params.get(0).toString());
        return new Identity(id);
    }

    private static Identity getIdentityFromIntParam(List<Object> params) {
        int id = Integer.parseInt(params.get(0).toString());
        return new Identity(id);
    }

    private static Translatable todo(CampaignDefectTranslations t) {
        return new DummyTranslatable("todo");
    }

    @Override
    public String getBundle() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Translatable getTranslatable(List<Object> params) {
        return translatableSupplier.apply(nvl(params, emptyList()));
    }
}
