package ru.yandex.autotests.directapi.apiclient.errors;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectTranslations;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.advqphrase.AdvqPhraseDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.validation.result.Path;

import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;
import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.validation.result.PathHelper.field;

public enum Api5ErrorDetailsJava implements ITextResource {
    MAXIMUM_GROUPS_IN_CAMPAIGN_REACHED(AdGroupDefectTranslations.class,
            t -> t.campaignAdGroupsLimitReached(Identity.of(1000L))),
    FIELD_MAXIMUM_LENGTH_EXCEEDED(CommonDefectTranslations.class,
            (t, params) -> t.lengthOfFieldValueMustNotExceed(
                    new Path(singletonList(field((String) params.get(0)))), params.get(1).toString())),
    MINUS_WORD_CANT_SUBTRACT_PLUS_WORDS_IN_KEYWORDS(AdvqPhraseDefectTranslations.class,
            (t, params) -> t.minusWordsCantSubtractPlusWords((String) params.get(0))),
    ONLY_SEPARATE_MINUS_WORDS_CAN_BE_EXCLUDED_FROM_KEYWORDS(AdvqPhraseDefectTranslations.class,
            AdvqPhraseDefectTranslations::minusWordsNoMinusPhrasesDetailed),
    KEYWORDS_COULD_NOT_CONSIST_OF_NEGATIVE_KEYWORDS_ONLY(AdvqPhraseDefectTranslations.class,
            AdvqPhraseDefectTranslations::minusWordsOnlyDetailed),
    ONLY_SEPARATE_WORDS_CAN_BE_EXCLUDED_FROM_KEYWORDS_PHRASES(AdvqPhraseDefectTranslations.class,
            AdvqPhraseDefectTranslations::minusWordsNoMinusPhrasesDetailed),
    BOTH_QUOTES_AND_MINUS_WORDS_IN_KEYWORDS(AdvqPhraseDefectTranslations.class,
            AdvqPhraseDefectTranslations::bothQuotesAndMinusWords),
    NO_MODIFIERS_INSIDE_SQUARE_BRACKETS_IN_KEYWORDS(AdvqPhraseDefectTranslations.class,
            AdvqPhraseDefectTranslations::invalidCharsModifiersInsideSquareBrackets),
    INCORRECT_USE_OF_EXCLAMATION_MARKS_IN_KEYWORDS(AdvqPhraseDefectTranslations.class,
            AdvqPhraseDefectTranslations::invalidCharsIncorrectUseOfExclamationMarks),
    INCORRECT_USE_OF_MINUS_SIGN_IN_KEYWORDS(AdvqPhraseDefectTranslations.class,
            AdvqPhraseDefectTranslations::invalidCharsIncorrectUseOfMinusSign),
    INCORRECT_USE_OF_PLUS_SIGN_IN_KEYWORDS(AdvqPhraseDefectTranslations.class,
            AdvqPhraseDefectTranslations::invalidCharsIncorrectUseOfPlusSign),
    INCORRECT_USE_OF_BRACKETS_IN_KEYWORDS(AdvqPhraseDefectTranslations.class,
            AdvqPhraseDefectTranslations::invalidCharsUnpairedSquareBracketsDetailed),
    INCORRECT_USE_OF_QUOTES_IN_KEYWORDS(AdvqPhraseDefectTranslations.class,
            AdvqPhraseDefectTranslations::invalidCharsUnpairedQuotesDetailed),
    INCORRECT_USE_OF_DOT_IN_KEYWORDS(AdvqPhraseDefectTranslations.class,
            AdvqPhraseDefectTranslations::invalidDot),
    KEYWORDS_COULD_NOT_CONTAIN_MORE_WORDS(AdvqPhraseDefectTranslations.class,
            (t, params) -> t.maxWordsDetailed((int) params.get(0))),
    KEYWORD_MAX_LENGTH_EXCEEDED_INDIVIDUAL(CommonDefectTranslations.class,
            (t, params) -> t.keywordMaxLengthDetailed((int) params.get(0))),
    KEYWORDS_COULD_NOT_CONSIST_OF_STOPWORDS_ONLY(AdvqPhraseDefectTranslations.class,
            AdvqPhraseDefectTranslations::stopWordsDetailed),
    INVALID_CHARS(CommonDefectTranslations.class,
            (t, params) -> t.invalidCharsDetailed(
                    new Path(singletonList(field((String) params.get(0)))))),
    MINUS_WORD_CANT_SUBTRACT_PLUS_WORDS(CommonDefectTranslations.class,
            (t, params) -> t.minusWordsCantSubtractPlusWords(
                    new Path(singletonList(field((String) params.get(0)))))),
    ONLY_SEPARATE_MINUS_WORDS_CAN_BE_EXCLUDED_FROM_KEYWORD(CommonDefectTranslations.class,
            (t, params) -> t.minusWordsNoMinusPhrasesDetailed(
                    new Path(singletonList(field((String) params.get(0)))))),
    KEYWORD_COULD_NOT_CONSIST_OF_NEGATIVE_KEYWORDS_ONLY(CommonDefectTranslations.class,
            (t, params) -> t.minusWordsOnlyDetailed(
                    new Path(singletonList(field((String) params.get(0)))))),
    ONLY_SEPARATE_WORDS_CAN_BE_EXCLUDED_FROM_KEYWORD_PHRASES(CommonDefectTranslations.class,
            (t, params) -> t.minusWordsNoMinusPhrasesDetailed(
                    new Path(singletonList(field((String) params.get(0)))))),
    BOTH_QUOTES_AND_MINUS_WORDS_IN_KEYWORD(CommonDefectTranslations.class,
            (t, params) -> t.bothQuotesAndMinusWords(
                    new Path(singletonList(field((String) params.get(0)))))),
    NO_MODIFIERS_INSIDE_SQUARE_BRACKETS(CommonDefectTranslations.class,
            (t, params) -> t.invalidCharsModifiersInsideSquareBrackets((String) params.get(0))),
    INCORRECT_USE_OF_EXCLAMATION_MARKS_IN_KEYWORD(CommonDefectTranslations.class,
            (t, params) -> t.invalidCharsIncorrectUseOfExclamationMarks((String) params.get(0))),
    INCORRECT_USE_OF_MINUS_SIGN_IN_KEYWORD(CommonDefectTranslations.class,
            (t, params) -> t.invalidCharsIncorrectUseOfMinusSign((String) params.get(0))),
    INCORRECT_USE_OF_PLUS_SIGN_IN_KEYWORD(CommonDefectTranslations.class,
            (t, params) -> t.invalidCharsIncorrectUseOfPlusSign((String) params.get(0))),
    INCORRECT_USE_OF_BRACKETS_IN_KEYWORD(CommonDefectTranslations.class,
            (t, params) -> t.invalidCharsUnpairedSquareBracketsDetailed((String) params.get(0))),
    KEYWORD_INCORRECT_USAGE_OF_QUOTES(CommonDefectTranslations.class,
            (t, params) -> t.invalidCharsUnpairedQuotesDetailed((String) params.get(0))),
    INCORRECT_USE_OF_DOT_IN_KEYWORD(CommonDefectTranslations.class,
            (t, params) -> t.invalidDot(
                    new Path(singletonList(field((String) params.get(0)))))),
    KEYWORD_COULD_NOT_CONTAIN_MORE_WORDS(CommonDefectTranslations.class,
            (t, params) -> t.maxWordsDetailed(
                    new Path(singletonList(field((String) params.get(0)))), (int) params.get(1))),
    KEYWORD_COULD_NOT_CONSIST_OF_STOPWORDS_ONLY(CommonDefectTranslations.class,
            (t, params) -> t.stopWordsDetailed(
                    new Path(singletonList(field((String) params.get(0)))))),
    ;

    @Override
    public String getBundle() {
        return null;
    }

    private final Function<List<Object>, Translatable> translatableSupplier;

    @Override
    public String getErrorText() {
        return null;
    }

    @Override
    public String getErrorText(String locale) {
        return null;
    }

    <T extends TranslationBundle> Api5ErrorDetailsJava(Class<T> bundleClass, Function<T, Translatable> textProducer) {
        T bundle = bundleClass.cast(I18NBundle.implement(bundleClass));
        translatableSupplier = params -> textProducer.apply(bundle);
    }

    <T extends TranslationBundle> Api5ErrorDetailsJava(Class<T> bundleClass,
                                                       BiFunction<T, List<Object>, Translatable> textProducer) {
        T bundle = bundleClass.cast(I18NBundle.implement(bundleClass));
        translatableSupplier = params -> textProducer.apply(bundle, params);
    }

    @Override
    public Translatable getTranslatable(List<Object> params) {
        return translatableSupplier.apply(nvl(params, emptyList()));
    }


}
