package ru.yandex.autotests.directapi.apiclient.errors;

import com.google.gson.annotations.SerializedName;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

import ru.yandex.autotests.directapi.apiclient.internal.JsonUtils;

/**
 * Created by chicos on 28.11.14.
 */
public class Api5JsonError extends RuntimeException implements Api5ErrorInfo {
    private static Logger log = LogManager.getLogger(Api5JsonError.class);
    @SerializedName("error_code")
    private Integer errorCode;
    @SerializedName("error_string")
    private String message;
    @SerializedName("error_detail")
    private String details;
    // Для того чтобы исключить данное поле из сериализации в строку
    private transient boolean javaResponse;

    public Api5JsonError() {
        super(new Exception());
    }

    public Integer getErrorCode() {
        return errorCode;
    }

    public Api5JsonError setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Override
    public String getErrorMessage() {
        return message;
    }

    @Override
    public String getErrorDetails() {
        return details;
    }

    public String getMessage() {
        return message;
    }

    public Api5JsonError setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getDetails() {
        return details;
    }

    public Api5JsonError setDetails(String details) {
        this.details = details;
        return this;
    }

    public boolean isJavaResponse() {
        return javaResponse;
    }

    public void setJavaResponse(boolean javaResponse) {
        this.javaResponse = javaResponse;
    }

    public String toString() {
        return JsonUtils.toString(this);
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Api5JsonError)) {
            return false;
        }

        Api5JsonError that = (Api5JsonError) o;

        if (details != null ? !details.equals(that.details) : that.details != null) {
            return false;
        }
        if (!errorCode.equals(that.errorCode)) {
            return false;
        }
        return message.equals(that.message);
    }

    @Override
    public synchronized int hashCode() {
        int result = errorCode.hashCode();
        result = 31 * result + message.hashCode();
        result = 31 * result + (details != null ? details.hashCode() : 0);
        return result;
    }
}
