package ru.yandex.autotests.directapi.apiclient.errors;

import java.io.StringWriter;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

import ru.yandex.autotests.directapi.exceptions.DirectAPIException;

/**
 * Created by pavryabov on 07.06.16.
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "ApiError")
@XmlType(propOrder = {"errorCode", "errorDetail", "errorMessage"})
public class Api5XmlError extends RuntimeException {

    private static Logger log = LogManager.getLogger(Api5XmlError.class);

    public Api5XmlError() {
        super(new Exception());
    }

    @XmlElement(name = "errorCode", required = true)
    private Integer errorCode;

    @XmlElement(name = "errorMessage", required = true)
    private String errorMessage;

    @XmlElement(name = "errorDetail", required = true)
    private String errorDetail;

    public Integer getErrorCode() {
        return errorCode;
    }

    public Api5XmlError setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public Api5XmlError setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public String getErrorDetail() {
        return errorDetail;
    }

    public Api5XmlError setErrorDetail(String errorDetail) {
        this.errorDetail = errorDetail;
        return this;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return new StackTraceElement[0];
    }

    public String toString() {
        String request;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(Api5XmlError.class);
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
            StringWriter stringWriter = new StringWriter();
            jaxbMarshaller.marshal(this, stringWriter);
            request = stringWriter.toString();
        } catch (JAXBException e) {
            throw new DirectAPIException("Ошибка формирования xml из объекта", e);
        }
        return request;
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Api5XmlError)) {
            return false;
        }

        Api5XmlError that = (Api5XmlError) o;

        if (errorDetail != null ? !errorDetail.equals(that.errorDetail) : that.errorDetail != null) {
            return false;
        }
        if (!errorCode.equals(that.errorCode)) {
            return false;
        }
        return errorMessage.equals(that.errorMessage);
    }

    @Override
    public synchronized int hashCode() {
        int result = errorCode.hashCode();
        result = 31 * result + errorMessage.hashCode();
        result = 31 * result + (errorDetail != null ? errorDetail.hashCode() : 0);
        return result;
    }
}
