package ru.yandex.autotests.directapi.apiclient.errors;

import java.util.List;
import java.util.Objects;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

/**
 * Created by pavryabov on 09.06.16.
 */
public class Api5XmlErrorMatcher extends TypeSafeDiagnosingMatcher<Api5XmlError> {
    private final Api5XmlError expectedError;
    private final boolean isCodeInIgnoreList;

    public Api5XmlErrorMatcher(Api5XmlError expected) {
        this.expectedError = expected;
        this.isCodeInIgnoreList = false;
    }

    public Api5XmlErrorMatcher(Api5XmlError expected, List<String> ignoreDetailForCodes) {
        this.expectedError = expected;
        this.isCodeInIgnoreList = ignoreDetailForCodes != null
                && ignoreDetailForCodes.contains(String.valueOf(expectedError.getErrorCode()));
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(
                (isCodeInIgnoreList) ?
                        ("error comparing only codes " + expectedError.toString()) :
                        ("error with details " + expectedError.toString()));
    }

    protected boolean matchesSafely(Api5XmlError item, Description mismatchDescription) {
        boolean matchesResult = true;
        //compare error message
        if (expectedError.getMessage() == null || expectedError.getMessage().equals("")) {
            matchesResult = item.getMessage() == null || item.getMessage().equals("");
        } else if (item.getMessage() == null || item.getMessage().equals("")) {
            matchesResult = false;
        } else {
            matchesResult = item.getMessage().equals(expectedError.getMessage());
        }

        //compare details only if error code not in ignore details list
        matchesResult = Objects.equals(expectedError.getErrorCode(), item.getErrorCode()) &&
                (isCodeInIgnoreList || matchesResult && expectedError.equals(item));
        if (!matchesResult) {
            mismatchDescription.appendText("\nerror was ");
            mismatchDescription.appendText(item.toString());
        }
        return matchesResult;
    }


    @Factory
    public static Matcher<Api5XmlError> equalToIgnoreLocale(Api5XmlError expectedError) {
        return new Api5XmlErrorMatcher(expectedError);
    }

    @Factory
    public static Matcher<Api5XmlError> equalToIgnoreLocale(Api5XmlError expectedError, List<String> ignoreDetailForCodes) {
        return new Api5XmlErrorMatcher(expectedError, ignoreDetailForCodes);
    }
}
