package ru.yandex.autotests.directapi.apiclient.internal;

import java.util.Map;

import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;

public abstract class BaseApiRequest {

    @SerializedName("params")
    protected Object parameters;

    @SerializedName("method")
    protected String method;

    protected transient Map<String, Object> header;

    public Object getParameters() {
        return parameters;
    }

    public void setParameters(Object parameters) {
        this.parameters = parameters;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Map<String, Object> getHeader() {
        return header;
    }

    public void setHeader(Map<String, Object> header) {
        this.header = header;
    }

    @Override
    public String toString() {
        String request = getRequestAsString();
        request = request.replaceAll("\"null\"", "null");
        return request;
    }

    public abstract String getRequestAsString();

    public abstract ProtocolType getProtocolType();
}
