package ru.yandex.autotests.directapi.apiclient.internal;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;

public class HashCodeCalcExclusionStrategy implements ExclusionStrategy {
    public boolean shouldSkipField(FieldAttributes f) {
        return f.getDeclaringClass().equals(Throwable.class)
                || f.getName().startsWith("__")
                || f.getName().equalsIgnoreCase("cause")
                || f.getName().equalsIgnoreCase("stacktrace")
                || f.getName().equalsIgnoreCase("suppressedexceptions")
                || f.getName().equalsIgnoreCase("prices")
                || f.getName().equalsIgnoreCase("coverage")
                || f.getName().equalsIgnoreCase("contextcoverage");
    }

    @Override
    public boolean shouldSkipClass(Class<?> aClass) {
        return false;
    }
}
