package ru.yandex.autotests.directapi.apiclient.internal;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;

public class HashCodeCalcExclusionStrategyV5 implements ExclusionStrategy {
    public HashCodeCalcExclusionStrategyV5() {
    }

    public boolean shouldSkipField(FieldAttributes f) {
        return f.getName().startsWith("__")
                || f.getName().toLowerCase().equals("cause")
                || f.getName().toLowerCase().equals("stacktrace")
                || f.getName().toLowerCase().equals("suppressedexceptions")
                || f.getName().toLowerCase().equals("prices")
                || f.getName().toLowerCase().equals("coverage");
    }

    public boolean shouldSkipClass(Class<?> aClass) {
        return false;
    }
}
