package ru.yandex.autotests.directapi.apiclient.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;

public class JAXBElementDeserializer implements JsonDeserializer<JAXBElement> {

    @Override
    public JAXBElement deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context)
            throws JsonParseException {
        Class valueType = (Class) ((ParameterizedType) type).getActualTypeArguments()[0];
        if (jsonElement.equals(new JsonPrimitive("null"))) {
            return new JAXBElement(new QName("Name"), valueType, null);
        }
        return new JAXBElement(new QName("Name"), valueType, context.deserialize(jsonElement, valueType));
    }
}
