package ru.yandex.autotests.directapi.apiclient.internal;

import java.lang.reflect.Type;

import javax.xml.bind.JAXBElement;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

public class JAXBElementSerializer implements JsonSerializer<JAXBElement> {
    @Override
    public JsonElement serialize(JAXBElement src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.isNil()) {
            return new JsonPrimitive("null");
        } else {
            return context.serialize(src.getValue());
        }
    }
}

