package ru.yandex.autotests.directapi.apiclient.internal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;

public class JSONRequest extends BaseApiRequest {

    public String getRequestAsString() {
        JsonObject jsonRequest = new JsonObject();
        jsonRequest.addProperty("method", method);
        if (parameters != null) {
            JsonElement params = JsonBuilder.gsonV5.toJsonTree(parameters);
            jsonRequest.add("params", params);
        }
        return JsonBuilder.gsonV5.toJson(jsonRequest);
    }

    @Override
    public ProtocolType getProtocolType() {
        return ProtocolType.JSON;
    }
}

