package ru.yandex.autotests.directapi.apiclient.internal;

import java.text.SimpleDateFormat;

import javax.xml.bind.JAXBElement;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class JsonBuilder {

    public static Gson gsonV5 = new GsonBuilder()
            .serializeSpecialFloatingPointValues()
            .setFieldNamingStrategy(FieldNamingPolicy.UPPER_CAMEL_CASE)
            .setExclusionStrategies(new HashCodeCalcExclusionStrategyV5())
            .setDateFormat(new SimpleDateFormat("yyyy-MM-dd").toPattern())
            .registerTypeAdapter(JAXBElement.class, new JAXBElementSerializer())
            .registerTypeAdapter(JAXBElement.class, new JAXBElementDeserializer())
            .registerTypeAdapter(byte[].class, new ByteArraySerializer())
            .registerTypeAdapter(Long.class, new LongDeserializer())
            .registerTypeHierarchyAdapter(Enum.class, new XMLBindEnumSerializer())
            .setPrettyPrinting()
            .create();
}
