package ru.yandex.autotests.directapi.apiclient.internal;

import java.lang.reflect.Type;
import java.text.SimpleDateFormat;

import javax.xml.bind.JAXBElement;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class JsonUtils {
    private static final String DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd").toPattern();

    public static Gson gsonInLine = new GsonBuilder()
            .serializeSpecialFloatingPointValues()
            .setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE)
            .setExclusionStrategies(new HashCodeCalcExclusionStrategy())
            .setDateFormat(DATE_FORMAT)
            .registerTypeAdapter(JAXBElement.class, new JAXBElementSerializer())
            .create();

    public static Gson gsonInLineDisabledHtmlEscaping = new GsonBuilder()
            .serializeSpecialFloatingPointValues()
            .setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE)
            .setExclusionStrategies(new HashCodeCalcExclusionStrategy())
            .setDateFormat(DATE_FORMAT)
            .registerTypeAdapter(JAXBElement.class, new JAXBElementSerializer())
            .disableHtmlEscaping()
            .create();

    private static Gson gson = new GsonBuilder()
            .serializeSpecialFloatingPointValues()
            .setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE)
            .setExclusionStrategies(new HashCodeCalcExclusionStrategy())
            .setDateFormat(DATE_FORMAT)
            .registerTypeAdapter(JAXBElement.class, new JAXBElementSerializer())
            .setPrettyPrinting()
            .create();

    private static Gson gsonDisabledHtmlEscaping = new GsonBuilder()
            .serializeSpecialFloatingPointValues()
            .setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE)
            .setExclusionStrategies(new HashCodeCalcExclusionStrategy())
            .setDateFormat(DATE_FORMAT)
            .registerTypeAdapter(JAXBElement.class, new JAXBElementSerializer())
            .setPrettyPrinting()
            .disableHtmlEscaping()
            .create();

    private static Gson gsonLow = new GsonBuilder()
            .serializeSpecialFloatingPointValues()
            .setFieldNamingPolicy(FieldNamingPolicy.IDENTITY)
            .setExclusionStrategies(new HashCodeCalcExclusionStrategy())
            .setDateFormat(DATE_FORMAT)
            .registerTypeAdapter(JAXBElement.class, new JAXBElementSerializer())
            .setPrettyPrinting()
            .create();

    private static Gson gsonLowInline = new GsonBuilder()
            .serializeSpecialFloatingPointValues()
            .setFieldNamingPolicy(FieldNamingPolicy.IDENTITY)
            .setExclusionStrategies(new HashCodeCalcExclusionStrategy())
            .setDateFormat(DATE_FORMAT)
            .registerTypeAdapter(JAXBElement.class, new JAXBElementSerializer())
            .create();

    private static Gson gsonWarning = new GsonBuilder()
            .serializeSpecialFloatingPointValues()
            .setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES)
            .setExclusionStrategies(new HashCodeCalcExclusionStrategy())
            .setDateFormat(DATE_FORMAT)
            .registerTypeAdapter(JAXBElement.class, new JAXBElementSerializer())
            .create();

    public static Gson gsonAssertion = new GsonBuilder()
            .serializeSpecialFloatingPointValues()
            .setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE)
            .setExclusionStrategies(new HashCodeCalcExclusionStrategy())
            .setDateFormat(DATE_FORMAT)
            .registerTypeAdapter(JAXBElement.class, new JAXBElementSerializer())
            .serializeNulls()
            .create();

    static public String toLowCaseString(Object object) {
        return gsonWarning.toJson(object);
    }

    static public String toString(Object object) {
        return toString(object, false);
    }

    static public String toStringWithNulls(Object object) {
        return gsonAssertion.toJson(object);
    }

    static public String toStringLow(Object object) {
        return toStringLow(object, false);
    }

    static public String toStringLow(Object object, boolean isInLinePrinting) {
        if (isInLinePrinting)
            return gsonLowInline.toJson(object);
        else
            return gsonLow.toJson(object);
    }

    static public String toString(Object object, boolean isInLinePrinting) {
        if (isInLinePrinting)
            return gsonInLine.toJson(object);
        else
            return gson.toJson(object);
    }

    static public String toStringDisabledHtmlEscaping(Object object, boolean isInLinePrinting) {
        if (isInLinePrinting) {
            return gsonInLineDisabledHtmlEscaping.toJson(object);
        } else {
            return gsonDisabledHtmlEscaping.toJson(object);
        }
    }

    static public String toString(Object object, Type arrayType) {
        return gson.toJson(object, arrayType);
    }

    static public <T> T getObject(String request, Class<T> c) {
        return gson.fromJson(request, c);
    }


    static public Object[] getObject(String request, Type arrayType) {
        return (Object[]) gson.fromJson(request, arrayType);
    }

    static public <T> T convertTo(Object original, Class<T> expectedClass) {
        String gsonObject = toString(original);
        return getObject(gsonObject, expectedClass);
    }
}
