package ru.yandex.autotests.directapi.apiclient.internal;

import java.util.Objects;

public class MethodInvocationResult<T> {
    private final T responseObject;
    private final boolean isJavaResponse;

    public MethodInvocationResult(T responseObject, boolean isJavaResponse) {
        this.responseObject = responseObject;
        this.isJavaResponse = isJavaResponse;
    }

    @Override
    public String toString() {
        return "MethodInvocationResult{" +
                "responseObject=" + responseObject +
                ", isJavaResponse=" + isJavaResponse +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MethodInvocationResult<?> that = (MethodInvocationResult<?>) o;
        return isJavaResponse == that.isJavaResponse &&
                Objects.equals(responseObject, that.responseObject);
    }

    @Override
    public int hashCode() {

        return Objects.hash(responseObject, isJavaResponse);
    }

    public T getResponseObject() {
        return responseObject;
    }

    public boolean isJavaResponse() {
        return isJavaResponse;
    }
}
