package ru.yandex.autotests.directapi.authentication;

import java.util.Optional;

import org.springframework.context.annotation.Lazy;

import ru.yandex.direct.api.v5.security.DirectApiCredentials;
import ru.yandex.direct.api.v5.security.SecurityErrors;
import ru.yandex.direct.api.v5.security.internal.DirectApiInternalAuthRequest;
import ru.yandex.direct.api.v5.security.token.ApiTokenAuthProvider;
import ru.yandex.direct.api.v5.security.token.DirectApiTokenAuthRequest;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

@Lazy
public class DummyApiTokenAuthProvider implements ApiTokenAuthProvider {
    private final ShardHelper shardHelper;

    public DummyApiTokenAuthProvider(ShardHelper shardHelper) {
        this.shardHelper = shardHelper;
    }

    @Override
    public DirectApiInternalAuthRequest authenticate(DirectApiTokenAuthRequest authRequest) {
        DirectApiCredentials credentials = authRequest.getCredentials();
        String operatorLogin = Optional
                .ofNullable(DummyAuthenticationContainer.getLogin(authRequest.getCredentials().getOauthToken()))
                .orElseThrow(() -> SecurityErrors.newInvalidOauthTokenFormat(new Exception("Invalid token")));
        String clientLogin = Optional.ofNullable(authRequest.getCredentials().getClientLogin()).orElse(operatorLogin);
        Long operatorUid = shardHelper.getUidByLogin(operatorLogin);

        return new DirectApiInternalAuthRequest(credentials, operatorUid, clientLogin, "Autotests", null);
    }
}
