package ru.yandex.autotests.directapi.authentication;

import java.util.UUID;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;

@ParametersAreNonnullByDefault
public class DummyAuthenticationContainer {
    private static final BiMap<String, String> tokensByLogin = HashBiMap.create();

    @Nullable
    public static String getToken(String login) {
        return tokensByLogin.get(login);
    }

    @Nullable
    public static String getLogin(String token) {
        return tokensByLogin.inverse().get(token);
    }

    public static void createTokenForLogin(String login) {
        tokensByLogin.put(login, UUID.randomUUID().toString());
    }
}
