package ru.yandex.autotests.directapi.configuration;

import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcProperty;
import ru.yandex.direct.common.db.PpcPropertyName;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

/**
 * Класс для работы с пропертями из БД, в котором отсутствует кеширование значений пропертей.
 */
@ParametersAreNonnullByDefault
public class TestPpcPropertiesSupport extends PpcPropertiesSupport {

    public TestPpcPropertiesSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public <T> PpcProperty<T> get(PpcPropertyName<T> name, Duration expiredDuration) {
        return super.get(name, null);
    }
}
