package ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.autotests.directapi.apiclient.internal.JsonUtils;
import ru.yandex.direct.core.entity.banner.model.old.OldBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithBody;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithCreative;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithTitle;
import ru.yandex.misc.lang.StringUtils;

public class BannerFakeInfo {
    @JsonProperty("bid")
    private Long bid;
    @JsonProperty("cid")
    private Integer cid;
    @JsonProperty("pid")
    private Long pid;
    @JsonProperty("vcard_id")
    private Integer vcardID;
    @JsonProperty("BannerID")
    private String bannerID;
    @JsonProperty("statusModerate")
    private String statusModerate;
    @JsonProperty("creative_statusModerate")
    private String creativeStatusModerate;
    @JsonProperty("creative_banner_creative_id")
    private String creativeBannerCreativeId;
    @JsonProperty("image_statusModerate")
    private String imageStatusModerate;
    @JsonProperty("image_image_id")
    private Long imageImageId;
    @JsonProperty("statusPostModerate")
    private String statusPostModerate;
    @JsonProperty("phoneflag")
    private String phoneFlag;
    @JsonProperty("sitelinks_set_id")
    private String sitelinksSetID;
    @JsonProperty("geoflag")
    private String geoFlag;
    @JsonProperty("body")
    private String body;
    @JsonProperty("domain")
    private String domain;
    @JsonProperty("href")
    private String href;
    @JsonProperty("title")
    private String title;
    @JsonProperty("flags")
    private String flags;
    @JsonProperty("LastChange")
    private String lastChange;
    @JsonProperty("login")
    private String login;
    @JsonProperty("statusSitelinksModerate")
    private String statusSitelinksModerate;
    @JsonProperty("statusShow")
    private String statusShow;
    @JsonProperty("statusActive")
    private String statusActive;
    @JsonProperty("reverse_domain")
    private String reverseDomain;
    @JsonProperty("statusBsSynced")
    private String statusBsSynced;
    @JsonProperty("imagead_statusModerate")
    private String imageadStatusModerate;
    @JsonProperty("imagead_image_id")
    private String imageadImageId;
    @JsonProperty("statusArch")
    private String statusArch;
    @JsonProperty("p_PriorityID")
    private String pPriorityID;
    @JsonProperty("p_statusModerate")
    private String pStatusModerate;
    @JsonProperty("p_statusPostModerate")
    private String pStatusPostModerate;
    @JsonProperty("p_statusBsSynced")
    private String pStatusBsSynced;
    @JsonProperty("p_statusAutobudgetShow")
    private String pStatusAutobudgetShow;
    @JsonProperty("p_ChoosedCategories")
    private String pChoosedCategories;
    @JsonProperty("p_forecastDate")
    private String pForecastDate;
    @JsonProperty("group_master_bid")
    private Integer groupMasterBid;
    @JsonProperty("image_BannerID")
    private Long imageBannerID;
    @JsonProperty("image_PriorityID")
    private Integer imagePriorityID;
    @JsonProperty("type")
    private String type;
    @JsonProperty("display_href_statusModerate")
    private String displayHrefStatusModerate;

    public BannerFakeInfo() {
    }

    public static BannerFakeInfo fromBanner(@Nullable OldBanner banner) {
        if (banner == null) {
            return null;
        }

        BannerFakeInfo bfi = new BannerFakeInfo();

        bfi.bid = banner.getId();
        bfi.bannerID = banner.getBsBannerId().toString();
        bfi.cid = banner.getCampaignId().intValue();
        bfi.pid = banner.getAdGroupId();

        bfi.domain = banner.getDomain();
        bfi.href = banner.getHref();

        bfi.statusActive = processStatus(banner.getStatusActive());
        bfi.statusArch = processStatus(banner.getStatusArchived());
        bfi.statusShow = processStatus(banner.getStatusShow());
        bfi.statusBsSynced = processStatus(banner.getStatusBsSynced());
        bfi.statusModerate = processStatus(banner.getStatusModerate());
        bfi.statusPostModerate = processStatus(banner.getStatusPostModerate());

        ifClassMatch(OldBannerWithBody.class, banner, bfi::setBody, OldBannerWithBody::getBody);
        ifClassMatch(OldBannerWithTitle.class, banner, bfi::setTitle, OldBannerWithTitle::getTitle);
        ifClassMatch(OldBannerWithCreative.class, banner, bfi::setCreativeBannerCreativeId,
                b -> Optional.ofNullable(b.getCreativeId()).map(Object::toString).orElse(null));
        ifClassMatch(OldBannerWithCreative.class, banner, bfi::setCreativeStatusModerate,
                b -> processStatus(b.getCreativeStatusModerate()));

        return bfi;
    }

    private static <T extends OldBanner, R> void ifClassMatch(Class<T> clazz, OldBanner b,
                                                           Consumer<R> setter, Function<T, R> getter) {
        if (clazz.isAssignableFrom(b.getClass())) {
            setter.accept(getter.apply((T) b));
        }
    }

    @Nullable
    private static String processStatus(@Nullable Enum<?> status) {
        return Optional.ofNullable(status)
                .map(Enum::name)
                .map(String::toLowerCase)
                .map(StringUtils::capitalize)
                .orElse(null);
    }

    @Nullable
    private static String processStatus(@Nullable Boolean status) {
        return Optional.ofNullable(status)
                .map(Objects::toString)
                .orElse(null);
    }

    public String getDisplayHrefStatusModerate() {
        return this.displayHrefStatusModerate;
    }

    public void setDisplayHrefStatusModerate(String displayHrefStatusModerate) {
        this.displayHrefStatusModerate = displayHrefStatusModerate;
    }

    public Long getBid() {
        return this.bid;
    }

    public void setBid(Long bid) {
        this.bid = bid;
    }

    public Integer getCid() {
        return this.cid;
    }

    public void setCid(Integer cid) {
        this.cid = cid;
    }

    public Integer getVcardID() {
        return this.vcardID;
    }

    public void setVcardID(Integer vcardID) {
        this.vcardID = vcardID;
    }

    public String getBannerID() {
        return this.bannerID;
    }

    public void setBannerID(String bannerID) {
        this.bannerID = bannerID;
    }

    public String getStatusModerate() {
        return this.statusModerate;
    }

    public void setStatusModerate(String statusModerate) {
        this.statusModerate = statusModerate;
    }

    public String getCreativeStatusModerate() {
        return this.creativeStatusModerate;
    }

    public void setCreativeStatusModerate(String creativeStatusModerate) {
        this.creativeStatusModerate = creativeStatusModerate;
    }

    public String getCreativeBannerCreativeId() {
        return this.creativeBannerCreativeId;
    }

    public void setCreativeBannerCreativeId(String creativeBannerCreativeId) {
        this.creativeBannerCreativeId = creativeBannerCreativeId;
    }

    public String getImageStatusModerate() {
        return this.imageStatusModerate;
    }

    public void setImageStatusModerate(String imageStatusModerate) {
        this.imageStatusModerate = imageStatusModerate;
    }

    public Long getImageImageID() {
        return this.imageImageId;
    }

    public void setImageImageID(Long imageImageId) {
        this.imageImageId = imageImageId;
    }

    public String getStatusPostModerate() {
        return this.statusPostModerate;
    }

    public void setStatusPostModerate(String statusPostModerate) {
        this.statusPostModerate = statusPostModerate;
    }

    public String getPhoneFlag() {
        return this.phoneFlag;
    }

    public void setPhoneFlag(String phoneFlag) {
        this.phoneFlag = phoneFlag;
    }

    public String getSitelinksSetID() {
        return this.sitelinksSetID;
    }

    public void setSitelinksSetID(String sitelinksSetID) {
        this.sitelinksSetID = sitelinksSetID;
    }

    public String getGeoFlag() {
        return this.geoFlag;
    }

    public void setGeoFlag(String geoFlag) {
        this.geoFlag = geoFlag;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFlags() {
        return this.flags;
    }

    public void setFlags(String flags) {
        this.flags = flags;
    }

    public String getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(String lastChange) {
        this.lastChange = lastChange;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getReverseDomain() {
        return this.reverseDomain;
    }

    public void setReverseDomain(String reverseDomain) {
        this.reverseDomain = reverseDomain;
    }

    public String getStatusSitelinksModerate() {
        return this.statusSitelinksModerate;
    }

    public void setStatusSitelinksModerate(String statusSitelinksModerate) {
        this.statusSitelinksModerate = statusSitelinksModerate;
    }

    public String getStatusShow() {
        return this.statusShow;
    }

    public void setStatusShow(String statusShow) {
        this.statusShow = statusShow;
    }

    public String getStatusActive() {
        return this.statusActive;
    }

    public void setStatusActive(String statusActive) {
        this.statusActive = statusActive;
    }

    public String getStatusBsSynced() {
        return this.statusBsSynced;
    }

    public void setStatusBsSynced(String statusBsSynced) {
        this.statusBsSynced = statusBsSynced;
    }

    public String getImageadStatusModerate() {
        return this.imageadStatusModerate;
    }

    public void setImageadStatusModerate(String imageadStatusModerate) {
        this.imageadStatusModerate = imageadStatusModerate;
    }

    public String getImageadImageId() {
        return this.imageadImageId;
    }

    public void setImageadImageId(String imageadImageId) {
        this.imageadImageId = imageadImageId;
    }

    public String getStatusArch() {
        return this.statusArch;
    }

    public void setStatusArch(String statusArch) {
        this.statusArch = statusArch;
    }

    public String getpPriorityID() {
        return this.pPriorityID;
    }

    public void setpPriorityID(String pPriorityID) {
        this.pPriorityID = pPriorityID;
    }

    public String getpStatusModerate() {
        return this.pStatusModerate;
    }

    public void setpStatusModerate(String pStatusModerate) {
        this.pStatusModerate = pStatusModerate;
    }

    public String getpStatusPostModerate() {
        return this.pStatusPostModerate;
    }

    public void setpStatusPostModerate(String pStatusPostModerate) {
        this.pStatusPostModerate = pStatusPostModerate;
    }

    public String getpStatusBsSynced() {
        return this.pStatusBsSynced;
    }

    public void setpStatusBsSynced(String pStatusBsSynced) {
        this.pStatusBsSynced = pStatusBsSynced;
    }

    public String getpStatusAutobudgetShow() {
        return this.pStatusAutobudgetShow;
    }

    public void setpStatusAutobudgetShow(String pStatusAutobudgetShow) {
        this.pStatusAutobudgetShow = pStatusAutobudgetShow;
    }

    public String getpChoosedCategories() {
        return this.pChoosedCategories;
    }

    public void setpChoosedCategories(String pChoosedCategories) {
        this.pChoosedCategories = pChoosedCategories;
    }

    public String getpForecastDate() {
        return this.pForecastDate;
    }

    public void setpForecastDate(String pForecastDate) {
        this.pForecastDate = pForecastDate;
    }

    public Long getPid() {
        return this.pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Integer getGroupMasterBid() {
        return this.groupMasterBid;
    }

    public void setGroupMasterBid(Integer groupMasterBid) {
        this.groupMasterBid = groupMasterBid;
    }

    public Long getImageBannerID() {
        return this.imageBannerID;
    }

    public void setImageBannerID(Long imageBannerID) {
        this.imageBannerID = imageBannerID;
    }

    public Integer getImagePriorityID() {
        return this.imagePriorityID;
    }

    public void setImagePriorityID(Integer imagePriorityID) {
        this.imagePriorityID = imagePriorityID;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getImageImageId() {
        return this.imageImageId;
    }

    public void setImageImageId(Long imageImageId) {
        this.imageImageId = imageImageId;
    }

    public String toString() {
        return JsonUtils.toString(this);
    }
}
