package ru.yandex.autotests.directapi.enums;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;

public enum DirectObjectType {
    TEXT(CampaignType.TEXT, AdGroupType.BASE, OldBannerType.TEXT),
    MOBILE_CONTENT(CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, OldBannerType.MOBILE_CONTENT),
    DYNAMIC(CampaignType.DYNAMIC, AdGroupType.DYNAMIC, OldBannerType.DYNAMIC),
    CPM_BANNER(CampaignType.CPM_BANNER, AdGroupType.CPM_BANNER, OldBannerType.CPM_BANNER);

    private CampaignType campaignType;
    private AdGroupType adGroupType;
    private OldBannerType bannerType;

    DirectObjectType(CampaignType campaignType, AdGroupType adGroupType, OldBannerType bannerType) {
        this.campaignType = campaignType;
        this.adGroupType = adGroupType;
        this.bannerType = bannerType;
    }

    public CampaignType getCampaignType() {
        return this.campaignType;
    }

    public AdGroupType getAdGroupType() {
        return this.adGroupType;
    }

    public OldBannerType getBannerType() {
        return this.bannerType;
    }

    public String toString() {
        return this.campaignType.toString();
    }
}
