package ru.yandex.autotests.directapi.matchers.beandiffer2;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanField;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.Differ;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.decorator.AllFieldsDifferDecorator;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.decorator.AllFieldsExceptDifferDecorator;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.decorator.OnlyExpectedFieldsDifferDecorator;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.decorator.OnlyFieldsDifferDecorator;

/**
 * Created by semkagtn on 17.11.15.
 */
public class Api5CompareStrategies {

    public static Api5CompareStrategy allFields() {
        return new AllFieldsApi5CompareStrategy();
    }

    public static Api5CompareStrategy onlyExpectedFields() {
        return new OnlyExpectedFieldsApi5CompareStrategy();
    }

    public static Api5CompareStrategy onlyFields(BeanFieldPath... fieldPaths) {
        return new OnlyFieldsApi5CompareStrategy(fieldPaths);
    }

    public static Api5CompareStrategy allFieldsExcept(BeanFieldPath... fieldPaths) {
        return new AllFieldsExceptApi5CompareStrategy(fieldPaths);
    }

    public static class AllFieldsApi5CompareStrategy extends Api5CompareStrategy {

        @Override
        public Differ getCustomOrDefaultDiffer(BeanField field) {
            return new AllFieldsDifferDecorator(super.getCustomOrDefaultDiffer(field));
        }
    }

    public static class OnlyExpectedFieldsApi5CompareStrategy extends Api5CompareStrategy {

        @Override
        public Differ getCustomOrDefaultDiffer(BeanField field) {
            return new OnlyExpectedFieldsDifferDecorator(super.getCustomOrDefaultDiffer(field));
        }
    }

    public static class OnlyFieldsApi5CompareStrategy extends Api5CompareStrategy {

        private final Set<BeanFieldPath> whiteList = new HashSet<>();

        @Override
        public Differ getCustomOrDefaultDiffer(BeanField field) {
            return new OnlyFieldsDifferDecorator(super.getCustomOrDefaultDiffer(field), whiteList);
        }

        private OnlyFieldsApi5CompareStrategy(BeanFieldPath[] beanFieldPaths) {
            Collections.addAll(whiteList, beanFieldPaths);
        }
    }

    public static class AllFieldsExceptApi5CompareStrategy extends Api5CompareStrategy {

        private final Set<BeanFieldPath> blackList = new HashSet<>();

        @Override
        public Differ getCustomOrDefaultDiffer(BeanField field) {
            return new AllFieldsExceptDifferDecorator(super.getCustomOrDefaultDiffer(field), blackList);
        }

        private AllFieldsExceptApi5CompareStrategy(BeanFieldPath[] beanFieldPaths) {
            Collections.addAll(blackList, beanFieldPaths);
        }
    }

    private Api5CompareStrategies() {

    }
}
