package ru.yandex.autotests.directapi.matchers.beandiffer2;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.xml.bind.JAXBElement;

import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanField;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategy;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.ArrayDiffer;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.BeanDiffer;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.CollectionDiffer;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.Differ;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.JaxbValueDiffer;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.ListDiffer;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.MapDiffer;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.SimpleTypeDiffer;

/**
 * Created by semkagtn on 17.11.15.
 */
public abstract class Api5CompareStrategy extends DefaultCompareStrategy {

    @Override
    public Differ getDefaultDiffer(BeanField field) {
        Class<?> type = field.getType();
        if (isSimpleType(type)) {
            return new SimpleTypeDiffer(field, this);
        } else if (JAXBElement.class.isAssignableFrom(type)) {
            return new JaxbValueDiffer(field, this);
        } else if (type.isArray()) {
            return new ArrayDiffer(field, this);
        } else if (List.class.isAssignableFrom(type)) {
            return new ListDiffer(field, this);
        } else if (Collection.class.isAssignableFrom(type)) {
            return new CollectionDiffer(field, this);
        }
        if (Map.class.isAssignableFrom(type)) {
            return new MapDiffer(field, this);
        } else {
            return new BeanDiffer(field, this);
        }
    }
}
