//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package ru.yandex.autotests.directapi.model;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.RandomUtils;

public class ValidImageData {
    public static Map<Integer, Image> regular = new HashMap<Integer, Image>() {
        {
            put(1, new Image("jpg 450X600", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/regular_450x600.jpg"));
            put(2, new Image("jpg 600X450", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/regular_600x450.jpg"));
            put(3, new Image("jpg 450X450", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/regular_450x450.jpg"));
            put(4, new Image("jpg 1200x900", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/regular_1200x900.jpg"));
            put(5, new Image("450x600 jpg", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/regularjpg.jpg"));
            put(6, new Image("jpg 600x800", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/regular600x800.jpg"));
            put(7, new Image("png", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/regular_png.png"));
            put(8, new Image("jpg", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/regular_jpg.jpg"));
            put(9, new Image("jpg 3750X5000", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/3750x5000.jpg"));
            put(10, new Image("jpg 5000X3750", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/5000x3750.jpg"));
            put(11, new Image("jpg 5000X5000", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/5000x5000.jpg"));
            put(12, new Image("gif 640X640", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/640x640.gif"));
        }
    };
    public static Map<Integer, Image> wide = new HashMap<Integer, Image>() {
        {
            put(1, new Image("jpg 1080x607", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/wide_1080x607.jpg"));
            put(2, new Image("jpg 1080x608", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/wide_1080x608.jpg"));
            put(3, new Image("jpg 5000X2813", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/5000x2813.jpg"));
        }
    };
    public static Map<Integer, Image> imageAd = new HashMap<Integer, Image>() {
        {
            put(1, new Image("gif 240x400", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/240x400.gif"));
            put(2, new Image("gif 728x90", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/728x90.gif"));
            put(3, new Image("jpg 728x90", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/728x90.jpg"));
            put(4, new Image("gif 300X250", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/300x250.gif"));
            put(5, new Image("pink jpg 728x90", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/pink_728x90.jpg"));
            put(6, new Image("blue jpg 728x90", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/blue_728x90.jpg"));
            put(7, new Image("300x600", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/300x600.jpg"));
            put(8, new Image("336x280", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/336x280.png"));
            put(9, new Image("300x500", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/300x500.jpg"));
            put(10, new Image("970x250", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/970x250.jpg"));
            put(11, new Image("640x100", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/640x100.jpg"));
            put(12, new Image("640x200", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/640x200.jpg"));
            put(13, new Image("640x960", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/640x960.jpg"));
            put(14, new Image("960x640", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/960x640.jpg"));
        }
    };
    public static Map<Integer, Image> fakeSmallFromImageAd = new HashMap<Integer, Image>() {
        {
            put(1, new Image("fake small brown jpg 728x90", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/fake_small_brown_728x90.jpg"));
            put(2, new Image("fake small green jpg 728x90", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/fake_small_green_728x90.jpg"));
            put(3, new Image("fake small purple jpg 728x90", "https://direct-qa-pub.s3.yandex.net/fcf9ad19f7/images/fake_small_purple_728x90.jpg"));
        }
    };

    public ValidImageData() {
    }

    public static Image getValidRegularImage() {
        return getValidRegularImage(RandomUtils.nextInt(1, regular.size()));
    }

    public static Image getValidRegularImage(int imageNumber) {
        return regular.get(imageNumber);
    }

    public static Image getValidWideImage() {
        return getValidWideImage(RandomUtils.nextInt(1, wide.size()));
    }

    public static Image getValidWideImage(int imageNumber) {
        return wide.get(imageNumber);
    }

    public static Image getValidImageAdImage(Integer imageNumber) {
        return imageAd.get(imageNumber != null ? imageNumber : RandomUtils.nextInt(1, imageAd.size()));
    }

    public static Image getValidImageAdImage() {
        return getValidImageAdImage(null);
    }

    public static Image getFakeSmallImage(Integer imageNumber) {
        return fakeSmallFromImageAd.get(imageNumber);
    }
}
