package ru.yandex.autotests.directapi.model.api5;

import java.util.stream.Stream;

public enum Action {
    GET("get"),
    SET("set"),
    SET_AUTO("setAuto"),
    ADD("add"),
    UPDATE("update"),
    DELETE("delete"),
    SUSPEND("suspend"),
    RESUME("resume"),
    ARCHIVE("archive"),
    UNARCHIVE("unarchive"),
    MODERATE("moderate"),
    TOGGLE("toggle"),
    CHECK_DICTIONARIES("checkDictionaries"),
    CHECK_CAMPAIGNS("checkCampaigns"),
    CHECK("check"),
    SET_BIDS("setBids"),
    HAS_SEARCH_VOLUME("hasSearchVolume"),
    DEDUPLICATE("deduplicate"),

    ACTION_EMPTY(""),
    ACTION_INVALID("asdf");

    private final String actionName;

    Action(String actionName) {
        this.actionName = actionName;
    }

    public static Action fromString(String methodName) {
        return Stream.of(values())
                .filter(v -> v.actionName.equalsIgnoreCase(methodName))
                .findFirst()
                .orElseThrow(IllegalArgumentException::new);
    }

    @Override
    public String toString() {
        return this.actionName;
    }
}
