package ru.yandex.autotests.directapi.model.api5.adgroups;

import java.util.Arrays;

import com.yandex.direct.api.v5.adgroups.AdGroupAddItem;
import com.yandex.direct.api.v5.adgroups.CpmBannerUserProfileAdGroupAdd;
import com.yandex.direct.api.v5.adgroups.SmartAdGroupAdd;
import com.yandex.direct.api.v5.general.ArrayOfString;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;

import static java.util.Collections.singletonList;

public class AdGroupAddItemMap {
    public static final String NAME = "name";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String REGION_IDS = "regionIds";
    public static final String NEGATIVE_KEYWORDS = "negativeKeywords";
    public static final String TRACKING_PARAMS = "trackingParams";
    public static final String MOBILE_APP_AD_GROUP = "mobileAppAdGroup";
    public static final String DYNAMIC_TEXT_AD_GROUP = "dynamicTextAdGroup";

    public static final String DEFAULT_TRACKING_PARAMS = "direct";
    public static final String DEFAULT_NAME = "newGroup";
    public static final String DEFAULT_NEGATIVE_KEYWORD = "подарки";
    public static final Long DEFAULT_REGION_ID = 0L;
    public static final int MAX_NAME_LENGTH = 255;
    public static final int MAX_WORDS_IN_NEGATIVE_KEYPHRASE = 7;
    public static final int MAX_NEGATIVE_KEYWORDS_LENGTH = 4096;

    public static final int GROUPS_MAX_LENGTH = 1000;

    private final AdGroupAddItem item;

    public AdGroupAddItemMap() {
        item = new AdGroupAddItem();
    }

    public AdGroupAddItem getBean() {
        return item;
    }

    public AdGroupAddItemMap defaultAdGroupAddItem(Long campaignId) {
        item.setCampaignId(campaignId);
        item.setName(DEFAULT_NAME);
        item.setRegionIds(singletonList(DEFAULT_REGION_ID));
        return this;
    }

    public AdGroupAddItemMap withCampaignId(Long campaignId) {
        item.setCampaignId(campaignId);
        return this;
    }

    public AdGroupAddItemMap withRegionIds(Long... regionIds) {
        item.setRegionIds(Arrays.asList(regionIds));
        return this;
    }

    public AdGroupAddItemMap withName(String name) {
        item.setName(name);
        return this;
    }

    public AdGroupAddItemMap withNegativeKeywords(String... negativeKeywords) {
        item.setNegativeKeywords(new ArrayOfString().withItems(negativeKeywords));
        return this;
    }

    public AdGroupAddItemMap withMobileAppAdGroupAddMap(MobileAppAdGroupAddMap group) {
        item.setMobileAppAdGroup(group.getBean());
        return this;
    }

    public AdGroupAddItemMap withDynamicTextAdGroup(DynamicTextAdGroupMap group) {
        item.setDynamicTextAdGroup(group.getBean());
        return this;
    }

    public AdGroupAddItemMap withPerformanceAdGroup(SmartAdGroupAdd group) {
        item.setSmartAdGroup(group);
        return this;
    }

    public AdGroupAddItemMap withDefaultGroup(AdGroupType type) {
        if (type == AdGroupType.MOBILE_CONTENT) {
            item.setMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup().getBean());

        } else if (type == AdGroupType.DYNAMIC) {
            item.setDynamicTextAdGroup(new DynamicTextAdGroupMap().defaultGroup().getBean());

        } else if (type == AdGroupType.CPM_BANNER) {
            item.setCpmBannerUserProfileAdGroup(new CpmBannerUserProfileAdGroupAdd());

        }
        return this;
    }
}
