package ru.yandex.autotests.directapi.model.api5.adgroups;

import com.yandex.direct.api.v5.adgroups.AdGroupGetItem;
import com.yandex.direct.api.v5.adgroups.AdGroupSubtypeEnum;
import com.yandex.direct.api.v5.adgroups.SmartAdGroupGet;
import com.yandex.direct.api.v5.general.AdGroupTypesEnum;
import com.yandex.direct.api.v5.general.ServingStatusEnum;
import com.yandex.direct.api.v5.general.StatusEnum;

public class AdGroupGetItemMap {

    private final AdGroupGetItem item;

    public AdGroupGetItemMap() {
        item = new AdGroupGetItem();
    }

    public AdGroupGetItem getBean() {
        return item;
    }

    public AdGroupGetItemMap withId(Long id) {
        item.withId(id);
        return this;
    }

    public AdGroupGetItemMap withCampaignId(Long campaignId) {
        item.withCampaignId(campaignId);
        return this;
    }

    public AdGroupGetItemMap withStatus(StatusEnum status) {
        item.withStatus(status);
        return this;
    }

    public AdGroupGetItemMap withName(String name) {
        item.withName(name);
        return this;
    }

    public AdGroupGetItemMap withType(AdGroupTypesEnum type) {
        item.withType(type);
        return this;
    }

    public AdGroupGetItemMap withSubtype(AdGroupSubtypeEnum subtype) {
        item.withSubtype(subtype);
        return this;
    }

    public AdGroupGetItemMap withServingStatus(ServingStatusEnum servingStatus) {
        item.withServingStatus(servingStatus);
        return this;
    }

     public AdGroupGetItemMap withRegionIds(Long... regionIds) {
        item.withRegionIds(regionIds);
        return this;
    }

    public AdGroupGetItemMap withSmartAdGroup(SmartAdGroupGet smartAdGroupGet) {
        item.withSmartAdGroup(smartAdGroupGet);
        return this;
    }
}
