package ru.yandex.autotests.directapi.model.api5.adgroups;

import java.util.Arrays;

import com.yandex.direct.api.v5.adgroups.AdGroupAppIconStatusSelectionEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupStatusSelectionEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupsSelectionCriteria;
import com.yandex.direct.api.v5.general.AdGroupTypesEnum;
import com.yandex.direct.api.v5.general.ServingStatusEnum;

public class AdGroupsSelectionCriteriaMap {
    private final AdGroupsSelectionCriteria request;

    public AdGroupsSelectionCriteriaMap() {
        request = new AdGroupsSelectionCriteria();
    }

    public AdGroupsSelectionCriteria getBean() {
        return request;
    }

    public AdGroupsSelectionCriteriaMap withCampaignIds(Long... campaignIds) {
        request.withCampaignIds(Arrays.asList(campaignIds));
        return this;
    }

    public AdGroupsSelectionCriteriaMap withIds(Long... ids) {
        request.withIds(Arrays.asList(ids));
        return this;
    }

    public AdGroupsSelectionCriteriaMap withStatuses(AdGroupStatusSelectionEnum... statuses) {
        request.withStatuses(Arrays.asList(statuses));
        return this;
    }

    public AdGroupsSelectionCriteriaMap withTagIds(Long... tagIds) {
        request.withTagIds(Arrays.asList(tagIds));
        return this;
    }

    public AdGroupsSelectionCriteriaMap withTags(String... tags) {
        request.withTags(Arrays.asList(tags));
        return this;
    }

    public AdGroupsSelectionCriteriaMap withTypes(AdGroupTypesEnum... types) {
        request.withTypes(Arrays.asList(types));
        return this;
    }

    public AdGroupsSelectionCriteriaMap withAppIconStatuses(AdGroupAppIconStatusSelectionEnum... statuses) {
        request.withAppIconStatuses(Arrays.asList(statuses));
        return this;
    }

    public AdGroupsSelectionCriteriaMap withServingStatuses(ServingStatusEnum... servingStatuses) {
        request.withServingStatuses(Arrays.asList(servingStatuses));
        return this;
    }
}
