package ru.yandex.autotests.directapi.model.api5.adgroups;

import java.util.stream.Stream;

import com.yandex.direct.api.v5.adgroups.AddRequest;

import static java.util.stream.Collectors.toList;

public class AddRequestMap {
    private final AddRequest request;

    public AddRequestMap() {
        request = new AddRequest();
    }

    public AddRequest getBean() {
        return request;
    }

    public AddRequestMap withAdGroups(AdGroupAddItemMap... items) {
        request.setAdGroups(Stream.of(items)
                .map(AdGroupAddItemMap::getBean)
                .collect(toList()));
        return this;
    }
}
