package ru.yandex.autotests.directapi.model.api5.adgroups;

import com.yandex.direct.api.v5.adgroups.DynamicTextAdGroup;

public class DynamicTextAdGroupMap {
    public static final String DOMAIN_URL = "domainUrl";
    public static final String ANOTHER_DOMAIN_URL = "another.yandex.com";
    public static final String DEFAULT_DOMAIN_URL = "test.yandex.ru";

    private final DynamicTextAdGroup item;

    public DynamicTextAdGroupMap() {
        item = new DynamicTextAdGroup();
    }

    public DynamicTextAdGroupMap withDomainUrl(String domainUrl) {
        item.setDomainUrl(domainUrl);
        return this;
    }

    public DynamicTextAdGroupMap defaultGroup() {
        item.setDomainUrl(DEFAULT_DOMAIN_URL);
        return this;
    }

    public DynamicTextAdGroup getBean() {
        return item;
    }
}
