package ru.yandex.autotests.directapi.model.api5.adgroups;

import java.util.Arrays;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.DynamicTextAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.DynamicTextFeedAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetRequest;
import com.yandex.direct.api.v5.adgroups.MobileAppAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.SmartAdGroupFieldEnum;

public class GetRequestMap {
    private final GetRequest request;

    public GetRequestMap() { request = new GetRequest(); }

    public GetRequest getBean() {
        return request;
    }

    public GetRequestMap withSelectionCriteria(AdGroupsSelectionCriteriaMap selectionCriteria) {
        request.withSelectionCriteria(selectionCriteria == null ? null : selectionCriteria.getBean());
        return this;
    }

    public GetRequestMap withFieldNames(AdGroupFieldEnum... fieldNames) {
        request.withFieldNames(Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withMobileAppAdGroupFieldNames(MobileAppAdGroupFieldEnum... fieldNames) {
        request.withMobileAppAdGroupFieldNames(Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withDynamicTextAdGroupFieldNames(DynamicTextAdGroupFieldEnum... fieldNames) {
        request.withDynamicTextAdGroupFieldNames(Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withDynamicTextFeedAdGroupFieldNames(DynamicTextFeedAdGroupFieldEnum... fieldNames) {
        request.withDynamicTextFeedAdGroupFieldNames(Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withSmartAdGroupFieldNames(SmartAdGroupFieldEnum... fieldNames) {
        request.withSmartAdGroupFieldNames(Arrays.asList(fieldNames));
        return this;
    }
}
