package ru.yandex.autotests.directapi.model.api5.adgroups;

import com.yandex.direct.api.v5.adgroups.MobileAppAdGroupAdd;
import com.yandex.direct.api.v5.adgroups.TargetCarrierEnum;
import com.yandex.direct.api.v5.adgroups.TargetDeviceTypeEnum;

public class MobileAppAdGroupAddMap {
    public static final String STORE_URL = "storeUrl";
    public static final String TARGET_DEVICE_TYPE = "targetDeviceType";
    public static final String TARGET_CARRIER = "targetCarrier";
    public static final String TARGET_OPERATING_SYSTEM_VERSION = "targetOperatingSystemVersion";
    public static final String ANDROID_STORE_URL =
            "http://play.google.com/store/apps/details?id=ru.yandex.searchplugin";
    public static final String DEFAULT_STORE_URL = ANDROID_STORE_URL;
    public static final String IOS_STORE_URL = "https://itunes.apple.com/ru/app/andeks.market/id425354015?mt=8";
    public static final String DEFAULT_TARGET_OPERATING_SYSTEM_VERSION = OSVersions.IOS_VERSIONS[9];
    public static final TargetDeviceTypeEnum[] DEFAULT_TARGET_DEVICE_TYPE
            = new TargetDeviceTypeEnum[]{TargetDeviceTypeEnum.DEVICE_TYPE_MOBILE,
            TargetDeviceTypeEnum.DEVICE_TYPE_TABLET};
    public static final TargetCarrierEnum DEFAULT_TARGET_CARRIER = TargetCarrierEnum.WI_FI_AND_CELLULAR;
    private final MobileAppAdGroupAdd item;

    public MobileAppAdGroupAddMap() {
        item = new MobileAppAdGroupAdd();
    }

    public MobileAppAdGroupAdd getBean() {
        return item;
    }

    public MobileAppAdGroupAddMap defaultGroup() {
        item
                .withStoreUrl(DEFAULT_STORE_URL)
                .withTargetDeviceType(DEFAULT_TARGET_DEVICE_TYPE)
                .withTargetCarrier(DEFAULT_TARGET_CARRIER)
                .withTargetOperatingSystemVersion(DEFAULT_TARGET_OPERATING_SYSTEM_VERSION);
        return this;
    }

    public static class OSVersions {
        public static final String[] ANDRIOD_VERSIONS =
                new String[]{"1.0", "1.1", "1.5", "1.6", "2.0", "2.1", "2.2", "2.3", "3.0", "3.1", "3.2", "4.0", "4.1",
                        "4.2", "4.3", "4.4", "5.0", "5.1"};
        public static final String[] IOS_VERSIONS =
                new String[]{"1.0", "2.0", "3.0", "3.1", "4.0", "4.1", "4.2", "5.0", "5.1", "6.0", "6.1", "7.0", "7.1",
                        "8.0", "8.1", "8.2", "8.3", "8.4", "9.0"};
    }
}
