package ru.yandex.autotests.directapi.model.api5.adgroups;

import java.util.stream.Stream;

import com.yandex.direct.api.v5.adgroups.UpdateRequest;

import static java.util.stream.Collectors.toList;

public class UpdateRequestMap {
    private final UpdateRequest request;

    public UpdateRequestMap() {
        request = new UpdateRequest();
    }

    public UpdateRequest getBean() {
        return request;
    }

    public UpdateRequestMap withAdGroups(AdGroupUpdateItemMap... items) {
        request.setAdGroups(Stream.of(items)
                .map(AdGroupUpdateItemMap::getBean)
                .collect(toList()));
        return this;
    }
}
